/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.k8s;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.hugegraph.HugeException;

public class K8sRegister {
    private static final String CA_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    private static final String KUBE_TOKEN_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String NAMESPACE_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    private static final String APP_NAME = System.getenv("APP_NAME");
    private static final String SERVICE_HOST = System.getenv("KUBERNETES_SERVICE_HOST");
    private static final String CERT_TYPE = "X.509";
    private static final String KEY_STORE_TYPE = "JKS";
    private static final String CERT_ALIAS = "ANY_CERTIFICATE_ALIAS";
    private static final String SSL_PROTO = "TLS";
    private HttpClient httpClient = null;

    private K8sRegister() {
    }

    public static K8sRegister instance() {
        return SingletonHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKubeToken() throws Exception {
        File file = new File(KUBE_TOKEN_FILE);
        if (file.canRead()) {
            FileReader reader = new FileReader(file);
            try (BufferedReader bufferedReader = new BufferedReader(reader);){
                String token = bufferedReader.readLine();
                String string = token = token.trim();
                return string;
            }
        }
        throw new HugeException("Kubernetes token file doesn't exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKubeNamespace() throws Exception {
        File file = new File(NAMESPACE_FILE);
        if (file.canRead()) {
            FileReader reader = new FileReader(file);
            try (BufferedReader bufferedReader = new BufferedReader(reader);){
                String namespace = bufferedReader.readLine();
                String string = namespace = namespace.trim();
                return string;
            }
        }
        throw new HugeException("Kubernetes namespace file doesn't exist");
    }

    public synchronized void initHttpClient() throws Exception {
        if (null != this.httpClient) {
            return;
        }
        CertificateFactory factory = CertificateFactory.getInstance(CERT_TYPE);
        Certificate cert = factory.generateCertificate(new FileInputStream(CA_FILE));
        KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
        keyStore.load(null, null);
        keyStore.setCertificateEntry(CERT_ALIAS, cert);
        TrustManagerFactory managerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        managerFactory.init(keyStore);
        SSLContext context = SSLContext.getInstance(SSL_PROTO);
        context.init(null, managerFactory.getTrustManagers(), null);
        CloseableHttpClient client = HttpClients.custom().setSSLContext(context).build();
        this.httpClient = client;
    }

    public String loadConfigStr() throws Exception {
        String token = this.getKubeToken();
        String namespace = this.getKubeNamespace();
        String url = String.format("https://%s/api/v1/namespaces/%s/services/%s", SERVICE_HOST, namespace, APP_NAME);
        HttpGet get = new HttpGet(url);
        get.setHeader("Authorization", "Bearer " + token);
        get.setHeader("Content-Type", "application/json");
        HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
        String configMap = EntityUtils.toString((HttpEntity)response.getEntity());
        return configMap;
    }

    private static class SingletonHolder {
        public static final K8sRegister instance = new K8sRegister();

        private SingletonHolder() {
        }
    }
}

