/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.consumer.impl.id;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.memory.consumer.OffHeapObject;
import org.apache.hugegraph.memory.pool.MemoryPool;
import org.apache.hugegraph.util.NumericUtil;

public class LongIdOffHeap
extends IdGenerator.LongId
implements OffHeapObject {
    private ByteBuf idOffHeap;

    public LongIdOffHeap(MemoryPool memoryPool, long id) {
        super(id);
        this.serializeSelfToByteBuf(memoryPool);
        this.releaseOriginalVarsOnHeap();
        memoryPool.bindMemoryConsumer(this);
    }

    public LongIdOffHeap(MemoryPool memoryPool, byte[] bytes) {
        super(bytes);
        this.serializeSelfToByteBuf(memoryPool);
        this.releaseOriginalVarsOnHeap();
        memoryPool.bindMemoryConsumer(this);
    }

    @Override
    public Object zeroCopyReadFromByteBuf() {
        try {
            IdGenerator.LongId longId = new IdGenerator.LongId(this.idOffHeap.readLong());
            return longId;
        }
        finally {
            this.idOffHeap.resetReaderIndex();
        }
    }

    @Override
    public void serializeSelfToByteBuf(MemoryPool memoryPool) {
        this.idOffHeap = (ByteBuf)memoryPool.requireMemory(8L, memoryPool);
        this.idOffHeap.markReaderIndex();
        this.idOffHeap.writeLong(this.id.longValue());
    }

    @Override
    public void releaseOriginalVarsOnHeap() {
        this.id = null;
    }

    @Override
    public List<ByteBuf> getAllMemoryBlock() {
        return Collections.singletonList(this.idOffHeap);
    }

    @Override
    public long asLong() {
        try {
            long l = this.idOffHeap.readLong();
            return l;
        }
        finally {
            this.idOffHeap.resetReaderIndex();
        }
    }

    @Override
    public Object asObject() {
        return this.asLong();
    }

    @Override
    public String asString() {
        return Long.toString(this.asLong());
    }

    @Override
    public byte[] asBytes() {
        return NumericUtil.longToBytes((long)this.asLong());
    }

    @Override
    public int compareTo(Id other) {
        int cmp = IdGenerator.compareType(this, other);
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare(this.asLong(), other.asLong());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.idOffHeap);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Number)) {
            return false;
        }
        return this.asLong() == ((Number)other).longValue();
    }

    @Override
    public String toString() {
        return String.valueOf(this.asLong());
    }

    @Override
    public int intValue() {
        return (int)this.asLong();
    }

    @Override
    public long longValue() {
        return this.asLong();
    }

    @Override
    public float floatValue() {
        return this.asLong();
    }

    @Override
    public double doubleValue() {
        return this.asLong();
    }
}

