/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.util;

public class RoundUtil {
    private static final long MB = 0x100000L;
    private static long ALIGNMENT = 8L;

    public static void setAlignment(long alignment) {
        ALIGNMENT = alignment;
    }

    public static long sizeAlign(long size) {
        long reminder = size % ALIGNMENT;
        return reminder == 0L ? size : size + ALIGNMENT - reminder;
    }

    public static long roundDelta(long reservedSize, long delta) {
        return RoundUtil.quantizedSize(reservedSize + delta) - reservedSize;
    }

    private static long quantizedSize(long size) {
        if (size < 0x1000000L) {
            return RoundUtil.roundUp(size, 0x100000L);
        }
        if (size < 0x4000000L) {
            return RoundUtil.roundUp(size, 0x400000L);
        }
        return RoundUtil.roundUp(size, 0x800000L);
    }

    private static long roundUp(long size, long factor) {
        return (size + factor - 1L) / factor * factor;
    }
}

