/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.records.record;

import org.apache.hugegraph.traversal.algorithm.records.record.Int2ArrayRecord;
import org.apache.hugegraph.traversal.algorithm.records.record.Int2IntRecord;
import org.apache.hugegraph.traversal.algorithm.records.record.Int2SetRecord;
import org.apache.hugegraph.traversal.algorithm.records.record.Record;
import org.apache.hugegraph.traversal.algorithm.records.record.RecordType;
import org.apache.hugegraph.traversal.algorithm.records.record.SyncRecord;

public class RecordFactory {
    public static Record newRecord(RecordType type) {
        return RecordFactory.newRecord(type, false);
    }

    public static Record newRecord(RecordType type, boolean concurrent) {
        Record record;
        switch (type) {
            case INT: {
                record = new Int2IntRecord();
                break;
            }
            case SET: {
                record = new Int2SetRecord();
                break;
            }
            case ARRAY: {
                record = new Int2ArrayRecord();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported record type: " + String.valueOf(type)));
            }
        }
        if (concurrent && !record.concurrent()) {
            record = new SyncRecord(record);
        }
        return record;
    }
}

