/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.hugegraph.store.HgKvEntry;
import org.apache.hugegraph.store.HgKvIterator;

class TopWorkIteratorProxy
implements HgKvIterator {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final Queue<HgKvIterator> queue;
    private final long limit;
    private HgKvIterator<HgKvEntry> iterator;
    private HgKvEntry entry;
    private int count;

    TopWorkIteratorProxy(List<HgKvIterator> iterators, long limit) {
        this.queue = new LinkedList<HgKvIterator>(iterators);
        this.limit = limit <= 0L ? Integer.MAX_VALUE : limit;
    }

    private HgKvIterator getIterator() {
        if (this.queue.isEmpty()) {
            return null;
        }
        HgKvIterator buf = null;
        while ((buf = this.queue.poll()) != null && !buf.hasNext()) {
        }
        if (buf == null) {
            return null;
        }
        this.queue.add(buf);
        return buf;
    }

    private void closeIterators() {
        HgKvIterator buf;
        if (this.queue.isEmpty()) {
            return;
        }
        while ((buf = this.queue.poll()) != null) {
            buf.close();
        }
    }

    private void setIterator() {
        this.iterator = null;
    }

    @Override
    public byte[] key() {
        if (this.entry != null) {
            return this.entry.key();
        }
        return null;
    }

    @Override
    public byte[] value() {
        if (this.entry != null) {
            return this.entry.value();
        }
        return null;
    }

    @Override
    public byte[] position() {
        return this.iterator != null ? this.iterator.position() : EMPTY_BYTES;
    }

    @Override
    public void seek(byte[] position) {
        if (this.iterator != null) {
            this.iterator.seek(position);
        }
    }

    @Override
    public boolean hasNext() {
        if ((long)this.count >= this.limit) {
            return false;
        }
        if (this.iterator == null) {
            this.iterator = this.getIterator();
        }
        return this.iterator != null;
    }

    @Override
    public Object next() {
        if (this.iterator == null) {
            this.hasNext();
        }
        if (this.iterator == null) {
            throw new NoSuchElementException();
        }
        this.entry = (HgKvEntry)this.iterator.next();
        this.setIterator();
        ++this.count;
        return this.entry;
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
        this.closeIterators();
    }
}

