/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import java.util.List;
import org.apache.hugegraph.store.HgKvEntry;
import org.apache.hugegraph.store.HgKvIterator;
import org.apache.hugegraph.store.HgKvOrderedIterator;
import org.apache.hugegraph.store.HgKvPagingIterator;
import org.apache.hugegraph.store.HgPageSize;
import org.apache.hugegraph.store.HgSeekAble;
import org.apache.hugegraph.store.client.HgStoreNodeSession;
import org.apache.hugegraph.store.client.grpc.GrpcKvEntryImpl;
import org.apache.hugegraph.store.client.grpc.KvCloseableIterator;
import org.apache.hugegraph.store.client.grpc.KvListIterator;
import org.apache.hugegraph.store.client.util.HgStoreClientConst;
import org.apache.hugegraph.store.client.util.HgStoreClientUtil;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcKvIteratorImpl
implements HgKvPagingIterator<HgKvEntry>,
HgKvOrderedIterator<HgKvEntry> {
    private static final Logger log = LoggerFactory.getLogger(GrpcKvIteratorImpl.class);
    private final byte[] emptyBytes = HgStoreClientConst.EMPTY_BYTES;
    private final KvCloseableIterator<Kv> iterator;
    private final HgPageSize pageLimiter;
    private final HgStoreNodeSession session;
    private HgKvEntry element;

    private GrpcKvIteratorImpl(HgStoreNodeSession session, KvCloseableIterator<Kv> iterator, HgPageSize pageLimiter) {
        this.iterator = iterator;
        this.pageLimiter = pageLimiter;
        this.session = session;
    }

    public static HgKvIterator<HgKvEntry> of(HgStoreNodeSession nodeSession, KvCloseableIterator<Kv> iterator) {
        if (iterator instanceof HgPageSize) {
            return GrpcKvIteratorImpl.of(nodeSession, iterator, (HgPageSize)((Object)iterator));
        }
        return new GrpcKvIteratorImpl(nodeSession, iterator, () -> 1L);
    }

    public static HgKvIterator<HgKvEntry> of(HgStoreNodeSession nodeSession, KvCloseableIterator<Kv> iterator, HgPageSize pageLimiter) {
        return new GrpcKvIteratorImpl(nodeSession, iterator, pageLimiter);
    }

    public static HgKvIterator<HgKvEntry> of(HgStoreNodeSession nodeSession, List<Kv> kvList) {
        int pageSize = kvList.size();
        return new GrpcKvIteratorImpl(nodeSession, new KvListIterator<Kv>(kvList), () -> pageSize);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public HgKvEntry next() {
        Kv kv = (Kv)this.iterator.next();
        this.element = new GrpcKvEntryImpl(kv.getKey().toByteArray(), kv.getValue().toByteArray(), kv.getCode());
        return this.element;
    }

    @Override
    public byte[] key() {
        if (this.element == null) {
            return null;
        }
        return this.element.key();
    }

    @Override
    public byte[] value() {
        if (this.element == null) {
            return null;
        }
        return this.element.value();
    }

    @Override
    public byte[] position() {
        if (this.element == null) {
            return this.emptyBytes;
        }
        byte[] key = this.element.key();
        if (key == null) {
            return this.emptyBytes;
        }
        if (!(this.iterator instanceof HgSeekAble)) {
            return this.emptyBytes;
        }
        byte[] upstream = ((HgSeekAble)((Object)this.iterator)).position();
        byte[] code = HgStoreClientUtil.toIntBytes(this.element.code());
        byte[] result = new byte[upstream.length + 4 + key.length];
        System.arraycopy(upstream, 0, result, 0, upstream.length);
        System.arraycopy(code, 0, result, upstream.length, 4);
        System.arraycopy(key, 0, result, upstream.length + 4, key.length);
        return result;
    }

    @Override
    public void seek(byte[] position) {
        if (this.iterator instanceof HgSeekAble) {
            ((HgSeekAble)((Object)this.iterator)).seek(position);
        }
    }

    @Override
    public long getPageSize() {
        return this.pageLimiter.getPageSize();
    }

    @Override
    public boolean isPageEmpty() {
        return !this.iterator.hasNext();
    }

    @Override
    public int compareTo(HgKvOrderedIterator o) {
        return Long.compare(this.getSequence(), o.getSequence());
    }

    @Override
    public long getSequence() {
        return this.session.getStoreNode().getNodeId();
    }

    @Override
    public void close() {
        this.iterator.close();
    }
}

