/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.store.client.grpc.GrpcStoreNodeImpl;
import org.apache.hugegraph.store.grpc.HealthyGrpc;
import org.apache.hugegraph.store.grpc.HealthyOuterClass;

@ThreadSafe
public final class GrpcNodeHealthyClient {
    private static final Map<String, ManagedChannel> CHANNEL_MAP = new ConcurrentHashMap<String, ManagedChannel>();
    private static final Map<String, HealthyGrpc.HealthyBlockingStub> STUB_MAP = new ConcurrentHashMap<String, HealthyGrpc.HealthyBlockingStub>();

    private ManagedChannel getChannel(String target) {
        ManagedChannel channel = CHANNEL_MAP.get(target);
        if (channel == null) {
            channel = ManagedChannelBuilder.forTarget((String)target).usePlaintext().build();
            CHANNEL_MAP.put(target, channel);
        }
        return channel;
    }

    private HealthyGrpc.HealthyBlockingStub getStub(String target) {
        HealthyGrpc.HealthyBlockingStub stub = STUB_MAP.get(target);
        if (stub == null) {
            stub = HealthyGrpc.newBlockingStub((Channel)this.getChannel(target));
            STUB_MAP.put(target, stub);
        }
        return stub;
    }

    boolean isHealthy(GrpcStoreNodeImpl node) {
        String target = node.getAddress();
        HealthyOuterClass.StringReply response = this.getStub(target).isOk(Empty.newBuilder().build());
        String res = response.getMessage();
        if ("ok".equals(res)) {
            return true;
        }
        System.out.printf("gRPC-res-msg: %s%n", res);
        return false;
    }

    public boolean isHealthy() {
        String target = "localhost:9080";
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)target).usePlaintext().build();
        HealthyGrpc.HealthyBlockingStub stub = HealthyGrpc.newBlockingStub((Channel)channel);
        HealthyOuterClass.StringReply response = stub.isOk(Empty.newBuilder().build());
        String res = response.getMessage();
        System.out.printf("gRPC response message:%s%n", res);
        return "ok".equals(res);
    }
}

