/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.palo;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.serializer.TableBackendEntry;
import org.apache.hugegraph.backend.store.TableDefine;
import org.apache.hugegraph.backend.store.mysql.MysqlSessions;
import org.apache.hugegraph.backend.store.mysql.MysqlTable;
import org.apache.hugegraph.backend.store.palo.PaloSessions;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class PaloTable
extends MysqlTable {
    private static final Logger LOG = Log.logger(PaloTable.class);

    public PaloTable(String table) {
        super(table);
    }

    public void createTable(MysqlSessions.Session session, TableDefine tableDefine) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE IF NOT EXISTS ");
        sql.append(this.table()).append(" (");
        int i = 0;
        for (Map.Entry entry : tableDefine.columns().entrySet()) {
            sql.append(PaloTable.formatKey((HugeKeys)((HugeKeys)entry.getKey())));
            sql.append(" ");
            sql.append((String)entry.getValue());
            if (++i == tableDefine.columns().size()) continue;
            sql.append(", ");
        }
        sql.append(")");
        sql.append(" UNIQUE KEY(");
        i = 0;
        for (HugeKeys key : tableDefine.keys()) {
            sql.append(PaloTable.formatKey((HugeKeys)key));
            if (++i == tableDefine.keys().size()) continue;
            sql.append(", ");
        }
        sql.append(")");
        sql.append(" DISTRIBUTED BY HASH(");
        i = 0;
        for (HugeKeys key : tableDefine.keys()) {
            sql.append(PaloTable.formatKey((HugeKeys)key));
            if (++i == tableDefine.keys().size()) continue;
            sql.append(", ");
        }
        sql.append(");");
        LOG.debug("Create table: {}", (Object)sql);
        try {
            session.execute(sql.toString());
        }
        catch (SQLException e) {
            throw new BackendException("Failed to create table with '%s'", (Throwable)e, new Object[]{sql});
        }
    }

    protected void appendPartition(StringBuilder delete) {
        delete.append(" PARTITION ").append(this.table());
    }

    public void insert(MysqlSessions.Session session, TableBackendEntry.Row entry) {
        assert (session instanceof PaloSessions.Session);
        PaloSessions.Session paloSession = (PaloSessions.Session)session;
        Set columnNames = this.tableDefine().columnNames();
        ArrayList<Object> columnValues = new ArrayList<Object>(columnNames.size());
        for (HugeKeys key : columnNames) {
            columnValues.add(entry.column(key));
        }
        String insert = StringUtils.join(columnValues, (String)"\t");
        paloSession.add(this.table(), insert);
    }
}

