/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.pulse;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.pd.grpc.pulse.PulseNoticeRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseResponse;
import org.apache.hugegraph.pd.grpc.pulse.PulseType;
import org.apache.hugegraph.pd.pulse.PulseListener;
import org.apache.hugegraph.pd.util.IdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
abstract class AbstractObserverSubject {
    private static final Logger log = LoggerFactory.getLogger(AbstractObserverSubject.class);
    private final Map<Long, StreamObserver<PulseResponse>> observerHolder = new ConcurrentHashMap(1024);
    private final Map<Long, PulseListener> listenerHolder = new ConcurrentHashMap(1024);
    private final byte[] lock = new byte[0];
    private final PulseResponse.Builder builder = PulseResponse.newBuilder();
    private final PulseType pulseType;

    protected AbstractObserverSubject(PulseType pulseType) {
        this.pulseType = pulseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addObserver(Long observerId, StreamObserver<PulseResponse> responseObserver) {
        Map map = this.observerHolder;
        synchronized (map) {
            if (this.observerHolder.containsKey(observerId)) {
                responseObserver.onError((Throwable)new Exception("The observer-id[" + observerId + "] of " + this.pulseType.name() + " subject has been existing."));
                return;
            }
            log.info("Adding a " + String.valueOf(this.pulseType) + "'s observer, observer-id is [" + observerId + "].");
            this.observerHolder.put(observerId, responseObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObserver(Long observerId, StreamObserver<PulseResponse> responseObserver) {
        Map map = this.observerHolder;
        synchronized (map) {
            log.info("Removing a " + String.valueOf(this.pulseType) + "'s observer, observer-id is [" + observerId + "].");
            this.observerHolder.remove(observerId);
        }
        responseObserver.onCompleted();
    }

    abstract String toNoticeString(PulseResponse var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long notifyClient(Consumer<PulseResponse.Builder> c) {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (c == null) {
                log.error(this.pulseType.name() + "'s notice was abandoned, caused by: notifyObserver(null)");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return -1L;
            }
            try {
                c.accept(this.builder.clear());
            }
            catch (Throwable t) {
                log.error(this.pulseType.name() + "'s notice was abandoned, caused by:", t);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return -1L;
            }
            long noticeId = IdUtil.createMillisId();
            for (Map.Entry entry : this.observerHolder.entrySet()) {
                Long observerId = (Long)entry.getKey();
                PulseResponse res = this.builder.setObserverId(observerId.longValue()).setNoticeId(noticeId).build();
                try {
                    ((StreamObserver)entry.getValue()).onNext((Object)res);
                }
                catch (Throwable e) {
                    log.error("Failed to send " + this.pulseType.name() + "'s notice[" + this.toNoticeString(res) + "] to observer[" + observerId + "].", e);
                    log.error("Removed a " + this.pulseType.name() + "'s observer[" + String.valueOf(entry.getKey()) + "], because of once failure of sending.", e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return noticeId;
        }
    }

    abstract long notifyClient(GeneratedMessageV3 var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyError(int code, String message) {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            for (Map.Entry entry : this.observerHolder.entrySet()) {
                Long observerId = (Long)entry.getKey();
                PulseResponse res = this.builder.setObserverId(observerId.longValue()).build();
                try {
                    ((StreamObserver)entry.getValue()).onError((Throwable)Status.fromCodeValue((int)code).withDescription(message).asRuntimeException());
                }
                catch (Throwable e) {
                    log.warn("Failed to send {} 's notice[{}] to observer[{}], error:{}", new Object[]{this.pulseType.name(), this.toNoticeString(res), observerId, e.getMessage()});
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(Long listenerId, PulseListener<?> listener) {
        Map map = this.listenerHolder;
        synchronized (map) {
            if (this.listenerHolder.containsKey(listenerId)) {
                listener.onError((Throwable)new Exception("The listener-id[" + listenerId + "] of " + this.pulseType.name() + " subject has been existing."));
                return;
            }
            log.info("Adding a " + String.valueOf(this.pulseType) + "'s listener, listener-id is [" + listenerId + "].");
            this.listenerHolder.put(listenerId, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(Long listenerId, PulseListener<?> listener) {
        Map map = this.listenerHolder;
        synchronized (map) {
            log.info("Removing a " + String.valueOf(this.pulseType) + "'s listener, listener-id is [" + listenerId + "].");
            this.observerHolder.remove(listenerId);
        }
        listener.onCompleted();
    }

    abstract <T> Function<PulseNoticeRequest, T> getNoticeHandler();

    void handleClientNotice(PulseNoticeRequest noticeRequest) throws Exception {
        for (Map.Entry entry : this.listenerHolder.entrySet()) {
            Long listenerId = (Long)entry.getKey();
            ((PulseListener)entry.getValue()).onNext(this.getNoticeHandler().apply(noticeRequest));
        }
    }
}

