/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.session;

import com.codahale.metrics.MetricRegistry;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.jsr223.JavaTranslator;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.GraphOp;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.util.BytecodeHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.handler.Frame;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.op.AbstractEvalOpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.server.op.session.Session;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.server.util.TraverserIterator;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionOpProcessor
extends AbstractEvalOpProcessor {
    private static final ObjectMapper mapper = GraphSONMapper.build().version(GraphSONVersion.V2_0).create().createMapper();
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"audit.org.apache.tinkerpop.gremlin.server");
    private static final Bindings EMPTY_BINDINGS = new SimpleBindings();
    private static final Logger logger = LoggerFactory.getLogger(SessionOpProcessor.class);
    public static final String OP_PROCESSOR_NAME = "session";
    protected static ConcurrentHashMap<String, Session> sessions = new ConcurrentHashMap();
    public static final String CONFIG_SESSION_TIMEOUT = "sessionTimeout";
    public static final String CONFIG_PER_GRAPH_CLOSE_TIMEOUT = "perGraphCloseTimeout";
    public static final String CONFIG_GLOBAL_FUNCTION_CACHE_ENABLED = "globalFunctionCacheEnabled";
    public static final long DEFAULT_SESSION_TIMEOUT = 28800000L;
    public static final long DEFAULT_PER_GRAPH_CLOSE_TIMEOUT = 10000L;
    static final Settings.ProcessorSettings DEFAULT_SETTINGS;

    public SessionOpProcessor() {
        super(false);
    }

    @Override
    public String getName() {
        return OP_PROCESSOR_NAME;
    }

    @Override
    public void init(Settings settings) {
        this.maxParameters = (Integer)settings.optionalProcessor(SessionOpProcessor.class).orElse((Settings.ProcessorSettings)SessionOpProcessor.DEFAULT_SETTINGS).config.getOrDefault("maxParameters", 16);
    }

    @Override
    public Optional<ThrowingConsumer<Context>> selectOther(Context ctx) throws OpProcessorException {
        RequestMessage requestMessage = ctx.getRequestMessage();
        if (requestMessage.getOp().equals("close")) {
            if (!requestMessage.optionalArgs(OP_PROCESSOR_NAME).isPresent()) {
                String msg = String.format("A message with an [%s] op code requires a [%s] argument", "close", OP_PROCESSOR_NAME);
                throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)requestMessage).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
            }
            return Optional.of(rhc -> rhc.writeAndFlush(ResponseMessage.build((RequestMessage)requestMessage).code(ResponseStatusCode.NO_CONTENT).create()));
        }
        if (requestMessage.getOp().equals("bytecode")) {
            SessionOpProcessor.validateTraversalSourceAlias(ctx, requestMessage, SessionOpProcessor.validateTraversalRequest(requestMessage));
            return Optional.of(this::iterateBytecodeTraversal);
        }
        return Optional.empty();
    }

    private static void validateTraversalSourceAlias(Context ctx, RequestMessage message, Map<String, String> aliases) throws OpProcessorException {
        String traversalSourceBindingForAlias = aliases.values().iterator().next();
        if (!ctx.getGraphManager().getTraversalSourceNames().contains(traversalSourceBindingForAlias)) {
            String msg = String.format("The traversal source [%s] for alias [%s] is not configured on the server.", traversalSourceBindingForAlias, "g");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
    }

    private static Map<String, String> validateTraversalRequest(RequestMessage message) throws OpProcessorException {
        if (!message.optionalArgs("gremlin").isPresent()) {
            String msg = String.format("A message with [%s] op code requires a [%s] argument.", "bytecode", "gremlin");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        return SessionOpProcessor.validatedAliases(message).get();
    }

    private static Optional<Map<String, String>> validatedAliases(RequestMessage message) throws OpProcessorException {
        Optional aliases = message.optionalArgs("aliases");
        if (!aliases.isPresent()) {
            String msg = String.format("A message with [%s] op code requires a [%s] argument.", "bytecode", "aliases");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        if (((Map)aliases.get()).size() != 1 || !((Map)aliases.get()).containsKey("g")) {
            String msg = String.format("A message with [%s] op code requires the [%s] argument to be a Map containing one alias assignment named '%s'.", "bytecode", "aliases", "g");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        return aliases;
    }

    @Override
    public ThrowingConsumer<Context> getEvalOp() {
        return this::evalOp;
    }

    @Override
    protected Optional<ThrowingConsumer<Context>> validateEvalMessage(RequestMessage message) throws OpProcessorException {
        super.validateEvalMessage(message);
        if (!message.optionalArgs(OP_PROCESSOR_NAME).isPresent()) {
            String msg = String.format("A message with an [%s] op code requires a [%s] argument", "eval", OP_PROCESSOR_NAME);
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        return Optional.empty();
    }

    @Override
    public void close() throws Exception {
        sessions.values().forEach(session -> session.manualKill(false));
    }

    protected void evalOp(Context context) throws OpProcessorException {
        RequestMessage msg = context.getRequestMessage();
        Session session = SessionOpProcessor.getSession(context, msg);
        if (!session.acceptingRequests()) {
            String sessionClosedMessage = String.format("Session %s is no longer accepting requests as it has been closed", session.getSessionId());
            ResponseMessage response = ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(sessionClosedMessage).create();
            throw new OpProcessorException(sessionClosedMessage, response);
        }
        if (!session.isBoundTo(context.getChannelHandlerContext().channel())) {
            String sessionClosedMessage = String.format("Session %s is not bound to the connecting client", session.getSessionId());
            ResponseMessage response = ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(sessionClosedMessage).create();
            throw new OpProcessorException(sessionClosedMessage, response);
        }
        context.getChannelHandlerContext().channel().attr(StateKey.SESSION).set((Object)session);
        this.evalOpInternal(context, session::getGremlinExecutor, this.getBindingMaker(session).apply(context));
    }

    protected static Session getSession(Context context, RequestMessage msg) {
        String sessionId = (String)msg.getArgs().get(OP_PROCESSOR_NAME);
        logger.debug("In-session request {} for eval for session {} in thread {}", new Object[]{msg.getRequestId(), sessionId, Thread.currentThread().getName()});
        Session session = sessions.computeIfAbsent(sessionId, k -> new Session((String)k, context, sessions));
        session.touch();
        return session;
    }

    protected Function<Context, AbstractEvalOpProcessor.BindingSupplier> getBindingMaker(Session session) {
        return context -> () -> {
            RequestMessage msg = context.getRequestMessage();
            Bindings bindings = session.getBindings();
            if (msg.getArgs().containsKey("aliases")) {
                Map aliases = (Map)msg.getArgs().get("aliases");
                for (Map.Entry aliasKv : aliases.entrySet()) {
                    TraversalSource ts;
                    boolean found = false;
                    Graph graph = context.getGraphManager().getGraph((String)aliasKv.getValue());
                    if (null != graph) {
                        bindings.put((String)aliasKv.getKey(), (Object)graph);
                        found = true;
                    }
                    if (!found && null != (ts = context.getGraphManager().getTraversalSource((String)aliasKv.getValue()))) {
                        bindings.put((String)aliasKv.getKey(), (Object)ts);
                        found = true;
                    }
                    if (found) continue;
                    String error = String.format("Could not alias [%s] to [%s] as [%s] not in the Graph or TraversalSource global bindings", aliasKv.getKey(), aliasKv.getValue(), aliasKv.getValue());
                    throw new OpProcessorException(error, ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(error).create());
                }
            }
            Optional.ofNullable((Map)msg.getArgs().get("bindings")).ifPresent(bindings::putAll);
            return bindings;
        };
    }

    private void iterateBytecodeTraversal(Context context) throws Exception {
        Traversal.Admin traversal;
        RequestMessage msg = context.getRequestMessage();
        Settings settings = context.getSettings();
        logger.debug("Traversal request {} for in thread {}", (Object)msg.getRequestId(), (Object)Thread.currentThread().getName());
        Object bytecodeObj = msg.getArgs().get("gremlin");
        Bytecode bytecode = bytecodeObj instanceof Bytecode ? (Bytecode)bytecodeObj : (Bytecode)mapper.readValue(bytecodeObj.toString(), Bytecode.class);
        Map aliases = (Map)msg.optionalArgs("aliases").get();
        Map args = msg.getArgs();
        long seto = args.containsKey("evaluationTimeout") ? ((Number)args.get("evaluationTimeout")).longValue() : context.getSettings().getEvaluationTimeout();
        GraphManager graphManager = context.getGraphManager();
        String traversalSourceName = (String)aliases.entrySet().iterator().next().getValue();
        TraversalSource g = graphManager.getTraversalSource(traversalSourceName);
        Session session = SessionOpProcessor.getSession(context, msg);
        if (BytecodeHelper.isGraphOperation((Bytecode)bytecode)) {
            this.handleGraphOperation(bytecode, g.getGraph(), context);
            return;
        }
        try {
            Optional lambdaLanguage = BytecodeHelper.getLambdaLanguage((Bytecode)bytecode);
            traversal = !lambdaLanguage.isPresent() ? JavaTranslator.of((TraversalSource)g).translate(bytecode) : session.getGremlinExecutor().eval(bytecode, EMPTY_BINDINGS, (String)lambdaLanguage.get(), traversalSourceName);
        }
        catch (ScriptException ex) {
            logger.error("Traversal contains a lambda that cannot be compiled", (Throwable)ex);
            throw new OpProcessorException("Traversal contains a lambda that cannot be compiled", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_EVALUATION).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
        }
        catch (Exception ex) {
            logger.error("Could not deserialize the Traversal instance", (Throwable)ex);
            throw new OpProcessorException("Could not deserialize the Traversal instance", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_SERIALIZATION).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
        }
        if (settings.enableAuditLog.booleanValue()) {
            String address;
            AuthenticatedUser user = (AuthenticatedUser)context.getChannelHandlerContext().channel().attr(StateKey.AUTHENTICATED_USER).get();
            if (null == user) {
                user = AuthenticatedUser.ANONYMOUS_USER;
            }
            if ((address = context.getChannelHandlerContext().channel().remoteAddress().toString()).startsWith("/") && address.length() > 1) {
                address = address.substring(1);
            }
            auditLogger.info("User {} with address {} requested: {}", new Object[]{user.getName(), address, bytecode});
        }
        if (settings.authentication.enableAuditLog) {
            String address = context.getChannelHandlerContext().channel().remoteAddress().toString();
            if (address.startsWith("/") && address.length() > 1) {
                address = address.substring(1);
            }
            auditLogger.info("User with address {} requested: {}", (Object)address, (Object)bytecode);
        }
        FutureTask<Void> evalFuture = new FutureTask<Void>(() -> {
            Graph graph = g.getGraph();
            try {
                this.beforeProcessing(graph, context);
                try {
                    traversal.applyStrategies();
                    this.handleIterator(context, new TraverserIterator(traversal), graph);
                }
                catch (Exception ex) {
                    Optional<Throwable> possibleTemporaryException;
                    Throwable t = ex;
                    if (ex instanceof UndeclaredThrowableException) {
                        t = t.getCause();
                    }
                    if ((possibleTemporaryException = SessionOpProcessor.determineIfTemporaryException(ex)).isPresent()) {
                        context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TEMPORARY).statusMessage(possibleTemporaryException.get().getMessage()).statusAttributeException(possibleTemporaryException.get()).create());
                    } else if (t instanceof InterruptedException || t instanceof TraversalInterruptedException) {
                        String errorMessage = String.format("A timeout occurred during traversal evaluation of [%s] - consider increasing the limit given to evaluationTimeout", msg);
                        logger.warn(errorMessage);
                        context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage(errorMessage).statusAttributeException((Throwable)ex).create());
                    } else {
                        logger.warn(String.format("Exception processing a Traversal on iteration for request [%s].", msg.getRequestId()), (Throwable)ex);
                        context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
                    }
                    this.onError(graph, context);
                }
            }
            catch (Exception ex) {
                Optional<Throwable> possibleTemporaryException = SessionOpProcessor.determineIfTemporaryException(ex);
                if (possibleTemporaryException.isPresent()) {
                    context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TEMPORARY).statusMessage(possibleTemporaryException.get().getMessage()).statusAttributeException(possibleTemporaryException.get()).create());
                } else {
                    logger.warn(String.format("Exception processing a Traversal on request [%s].", msg.getRequestId()), (Throwable)ex);
                    context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
                }
                this.onError(graph, context);
            }
            return null;
        });
        SessionOpProcessor.submitToGremlinExecutor(context, seto, session, evalFuture);
    }

    private static void submitToGremlinExecutor(Context context, long seto, Session session, FutureTask<Void> evalFuture) {
        Future<?> executionFuture = session.getGremlinExecutor().getExecutorService().submit(evalFuture);
        if (seto > 0L) {
            context.getScheduledExecutorService().schedule(() -> executionFuture.cancel(true), seto, TimeUnit.MILLISECONDS);
        }
    }

    protected void handleGraphOperation(Bytecode bytecode, Graph graph, Context context) {
        RequestMessage msg = context.getRequestMessage();
        Session session = SessionOpProcessor.getSession(context, msg);
        if (graph.features().graph().supportsTransactions()) {
            if (GraphOp.TX_COMMIT.equals(bytecode) || GraphOp.TX_ROLLBACK.equals(bytecode)) {
                boolean commit = GraphOp.TX_COMMIT.equals(bytecode);
                SessionOpProcessor.submitToGremlinExecutor(context, 0L, session, new FutureTask<Void>(() -> {
                    try {
                        if (graph.tx().isOpen()) {
                            if (commit) {
                                graph.tx().commit();
                            } else {
                                graph.tx().rollback();
                            }
                        }
                        Map<String, Object> attributes = this.generateStatusAttributes(context.getChannelHandlerContext(), msg, ResponseStatusCode.NO_CONTENT, Collections.emptyIterator(), context.getSettings());
                        context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.NO_CONTENT).statusAttributes(attributes).create());
                    }
                    catch (Exception ex) {
                        Optional<Throwable> possibleTemporaryException = SessionOpProcessor.determineIfTemporaryException(ex);
                        if (possibleTemporaryException.isPresent()) {
                            context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TEMPORARY).statusMessage(possibleTemporaryException.get().getMessage()).statusAttributeException(possibleTemporaryException.get()).create());
                        } else {
                            logger.warn(String.format("Exception processing a Traversal on request [%s].", msg.getRequestId()), (Throwable)ex);
                            context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
                        }
                        this.onError(graph, context);
                    }
                    return null;
                }));
            } else {
                throw new IllegalStateException(String.format("Bytecode in request is not a recognized graph operation: %s", bytecode.toString()));
            }
        }
    }

    protected void beforeProcessing(Graph graph, Context ctx) {
        boolean managedTransactionsForRequest;
        boolean bl = managedTransactionsForRequest = this.manageTransactions ? true : ctx.getRequestMessage().getArgs().getOrDefault("manageTransaction", false);
        if (managedTransactionsForRequest && graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
            graph.tx().rollback();
        }
    }

    protected void onError(Graph graph, Context ctx) {
        boolean managedTransactionsForRequest;
        boolean bl = managedTransactionsForRequest = this.manageTransactions ? true : ctx.getRequestMessage().getArgs().getOrDefault("manageTransaction", false);
        if (managedTransactionsForRequest && graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
            graph.tx().rollback();
        }
    }

    protected void onTraversalSuccess(Graph graph, Context ctx) {
        boolean managedTransactionsForRequest;
        boolean bl = managedTransactionsForRequest = this.manageTransactions ? true : ctx.getRequestMessage().getArgs().getOrDefault("manageTransaction", false);
        if (managedTransactionsForRequest && graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
            graph.tx().commit();
        }
    }

    protected void handleIterator(Context context, Iterator itty, Graph graph) throws InterruptedException {
        ChannelHandlerContext nettyContext = context.getChannelHandlerContext();
        RequestMessage msg = context.getRequestMessage();
        Settings settings = context.getSettings();
        MessageSerializer serializer = (MessageSerializer)nettyContext.channel().attr(StateKey.SERIALIZER).get();
        boolean useBinary = (Boolean)nettyContext.channel().attr(StateKey.USE_BINARY).get();
        boolean warnOnce = false;
        if (!itty.hasNext()) {
            Map<String, Object> attributes = this.generateStatusAttributes(nettyContext, msg, ResponseStatusCode.NO_CONTENT, itty, settings);
            this.onTraversalSuccess(graph, context);
            context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.NO_CONTENT).statusAttributes(attributes).create());
            return;
        }
        int resultIterationBatchSize = msg.optionalArgs("batchSize").orElse(settings.resultIterationBatchSize);
        ArrayList<Object> aggregate = new ArrayList<Object>(resultIterationBatchSize);
        boolean hasMore = itty.hasNext();
        while (hasMore) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            boolean forceFlush = this.isForceFlushed(nettyContext, msg, itty);
            if (aggregate.size() < resultIterationBatchSize && itty.hasNext() && !forceFlush) {
                aggregate.add(itty.next());
            }
            if (!nettyContext.channel().isActive()) {
                this.onError(graph, context);
                break;
            }
            if (nettyContext.channel().isActive() && nettyContext.channel().isWritable()) {
                if (!forceFlush && aggregate.size() != resultIterationBatchSize && itty.hasNext()) continue;
                ResponseStatusCode code = itty.hasNext() ? ResponseStatusCode.PARTIAL_CONTENT : ResponseStatusCode.SUCCESS;
                Map<String, Object> metadata = this.generateResultMetaData(nettyContext, msg, code, itty, settings);
                Map<String, Object> statusAttrb = this.generateStatusAttributes(nettyContext, msg, code, itty, settings);
                Frame frame = null;
                try {
                    frame = SessionOpProcessor.makeFrame(context, msg, serializer, useBinary, aggregate, code, metadata, statusAttrb);
                }
                catch (Exception ex) {
                    if (frame != null) {
                        frame.tryRelease();
                    }
                    this.onError(graph, context);
                    break;
                }
                try {
                    if (itty.hasNext()) {
                        aggregate = new ArrayList(resultIterationBatchSize);
                    } else {
                        this.onTraversalSuccess(graph, context);
                        hasMore = false;
                    }
                }
                catch (Exception ex) {
                    if (frame != null) {
                        frame.tryRelease();
                    }
                    throw ex;
                }
                if (!itty.hasNext()) {
                    this.iterateComplete(nettyContext, msg, itty);
                }
                context.writeAndFlush(code, frame);
                continue;
            }
            if (!warnOnce) {
                logger.warn("Pausing response writing as writeBufferHighWaterMark exceeded on {} - writing will continue once client has caught up", (Object)msg);
                warnOnce = true;
            }
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }

    static {
        MetricManager.INSTANCE.getGuage(sessions::size, MetricRegistry.name(GremlinServer.class, (String[])new String[]{"sessions"}));
        DEFAULT_SETTINGS = new Settings.ProcessorSettings();
        SessionOpProcessor.DEFAULT_SETTINGS.className = SessionOpProcessor.class.getCanonicalName();
        SessionOpProcessor.DEFAULT_SETTINGS.config = new HashMap<String, Object>(){
            {
                this.put(SessionOpProcessor.CONFIG_SESSION_TIMEOUT, 28800000L);
                this.put(SessionOpProcessor.CONFIG_PER_GRAPH_CLOSE_TIMEOUT, 10000L);
                this.put("maxParameters", 16);
                this.put(SessionOpProcessor.CONFIG_GLOBAL_FUNCTION_CACHE_ENABLED, true);
            }
        };
    }
}

