/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.hugegraph.pd.client.DiscoveryClient;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfo;
import org.apache.hugegraph.pd.grpc.discovery.RegisterType;

public class DiscoveryClientImpl
extends DiscoveryClient {
    private final String id;
    private final RegisterType type;
    private final String version;
    private final String appName;
    private final int times;
    private final String address;
    private final Map labels;
    private final Consumer registerConsumer;
    private PDConfig conf;

    private DiscoveryClientImpl(Builder builder) {
        super(builder.centerAddress, builder.delay, builder.conf);
        this.period = builder.delay;
        this.id = builder.id;
        this.type = builder.type;
        this.version = builder.version;
        this.appName = builder.appName;
        this.times = builder.times;
        this.address = builder.address;
        this.labels = builder.labels;
        this.registerConsumer = builder.registerConsumer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    NodeInfo getRegisterNode() {
        return NodeInfo.newBuilder().setAddress(this.address).setVersion(this.version).setAppName(this.appName).setInterval((long)this.period).setId(this.id).putAllLabels(this.labels).build();
    }

    Consumer getRegisterConsumer() {
        return this.registerConsumer;
    }

    public static final class Builder {
        private int delay;
        private String centerAddress;
        private String id;
        private RegisterType type;
        private String address;
        private Map labels;
        private String version;
        private String appName;
        private int times;
        private Consumer registerConsumer;
        private PDConfig conf;

        private Builder() {
        }

        public Builder setDelay(int val) {
            this.delay = val;
            return this;
        }

        public Builder setCenterAddress(String val) {
            this.centerAddress = val;
            return this;
        }

        public Builder setId(String val) {
            this.id = val;
            return this;
        }

        public Builder setType(RegisterType val) {
            this.type = val;
            return this;
        }

        public Builder setAddress(String val) {
            this.address = val;
            return this;
        }

        public Builder setLabels(Map val) {
            this.labels = val;
            return this;
        }

        public Builder setVersion(String val) {
            this.version = val;
            return this;
        }

        public Builder setAppName(String val) {
            this.appName = val;
            return this;
        }

        public Builder setTimes(int val) {
            this.times = val;
            return this;
        }

        public Builder setPdConfig(PDConfig val) {
            this.conf = val;
            return this;
        }

        public Builder setRegisterConsumer(Consumer registerConsumer) {
            this.registerConsumer = registerConsumer;
            return this;
        }

        public DiscoveryClientImpl build() {
            return new DiscoveryClientImpl(this);
        }
    }
}

