/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.rocksdb;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBIteratorPool;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.rocksdb.Checkpoint;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.SstFileManager;
import org.slf4j.Logger;

public class OpenedRocksDB
implements AutoCloseable {
    private static final Logger LOG = Log.logger(OpenedRocksDB.class);
    private final RocksDB rocksdb;
    private final Map<String, CFHandle> cfHandles;
    private final SstFileManager sstFileManager;

    public OpenedRocksDB(RocksDB rocksdb, Map<String, CFHandle> cfHandles, SstFileManager sstFileManager) {
        this.rocksdb = rocksdb;
        this.cfHandles = cfHandles;
        this.sstFileManager = sstFileManager;
    }

    protected final RocksDB rocksdb() {
        return this.rocksdb;
    }

    public Set<String> cfs() {
        return this.cfHandles.keySet();
    }

    public CFHandle cf(String cfName) {
        return this.cfHandles.get(cfName);
    }

    public void addCf(String cfName, CFHandle cfHandle) {
        this.cfHandles.put(cfName, cfHandle);
    }

    public CFHandle removeCf(String cfName) {
        return this.cfHandles.remove(cfName);
    }

    public boolean existCf(String cfName) {
        return this.cfHandles.containsKey(cfName);
    }

    public boolean isOwningHandle() {
        return this.rocksdb.isOwningHandle();
    }

    @Override
    public void close() {
        if (!this.isOwningHandle()) {
            return;
        }
        for (CFHandle cf : this.cfHandles.values()) {
            cf.close();
        }
        this.cfHandles.clear();
        this.rocksdb.close();
    }

    public long totalSize() {
        return this.sstFileManager.getTotalSize();
    }

    public void createCheckpoint(String targetPath) {
        Path parentName = Paths.get(targetPath, new String[0]).toAbsolutePath().getParent().getFileName();
        assert (parentName.toString().startsWith("snapshot")) : targetPath;
        try (Checkpoint checkpoint = Checkpoint.create((RocksDB)this.rocksdb);){
            String tempPath = targetPath + "_temp";
            File tempFile = new File(tempPath);
            FileUtils.deleteDirectory((File)tempFile);
            LOG.debug("Deleted temp directory {}", (Object)tempFile);
            FileUtils.forceMkdir((File)tempFile.getParentFile());
            checkpoint.createCheckpoint(tempPath);
            File snapshotFile = new File(targetPath);
            FileUtils.deleteDirectory((File)snapshotFile);
            LOG.debug("Deleted stale directory {}", (Object)snapshotFile);
            if (!tempFile.renameTo(snapshotFile)) {
                throw new IOException(String.format("Failed to rename %s to %s", tempFile, snapshotFile));
            }
        }
        catch (Exception e) {
            throw new BackendException("Failed to create checkpoint at path %s", (Throwable)e, new Object[]{targetPath});
        }
    }

    protected static final class CFHandle
    implements AutoCloseable {
        private final ColumnFamilyHandle handle;
        private final AtomicInteger refs;
        private final RocksDBIteratorPool iterPool;

        public CFHandle(RocksDB rocksdb, ColumnFamilyHandle handle) {
            E.checkNotNull((Object)handle, (String)"handle");
            this.handle = handle;
            this.refs = new AtomicInteger(1);
            this.iterPool = new RocksDBIteratorPool(rocksdb, this.handle);
        }

        public synchronized ColumnFamilyHandle get() {
            E.checkState((boolean)this.handle.isOwningHandle(), (String)"It seems CF has been closed", (Object[])new Object[0]);
            assert (this.refs.get() >= 1);
            return this.handle;
        }

        public synchronized RocksDBIteratorPool.ReusedRocksIterator newIterator() {
            assert (this.handle.isOwningHandle());
            assert (this.refs.get() >= 1);
            return this.iterPool.newIterator();
        }

        public synchronized void open() {
            this.refs.incrementAndGet();
        }

        @Override
        public void close() {
            if (this.refs.decrementAndGet() <= 0) {
                this.iterPool.close();
                this.handle.close();
            }
        }

        public synchronized ColumnFamilyHandle waitForDrop() {
            assert (this.refs.get() >= 1);
            long timeout = TimeUnit.MINUTES.toMillis(30L);
            long unit = 100L;
            long i = 1L;
            while (this.refs.get() > 1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (i * 100L > timeout) {
                    throw new BackendException("Timeout after %sms to drop CF", new Object[]{timeout});
                }
                ++i;
            }
            assert (this.refs.get() == 1);
            return this.handle;
        }

        public synchronized void destroy() {
            this.close();
            assert (this.refs.get() == 0 && !this.handle.isOwningHandle());
        }
    }
}

