/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.controller;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hugegraph.HugeGraphSupplier;
import org.apache.hugegraph.backend.BackendColumn;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.rocksdb.access.SessionOperator;
import org.apache.hugegraph.rocksdb.access.SessionOperatorImpl;
import org.apache.hugegraph.serializer.BinaryElementSerializer;
import org.apache.hugegraph.store.business.BusinessHandler;
import org.apache.hugegraph.store.business.BusinessHandlerImpl;
import org.apache.hugegraph.store.business.InnerKeyCreator;
import org.apache.hugegraph.store.meta.GraphIdManager;
import org.apache.hugegraph.store.meta.MetadataKeyHelper;
import org.apache.hugegraph.store.meta.base.DBSessionBuilder;
import org.apache.hugegraph.store.node.grpc.HgStoreNodeService;
import org.apache.hugegraph.store.node.grpc.query.QueryUtil;
import org.apache.hugegraph.structure.BaseElement;
import org.apache.hugegraph.structure.BaseProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/fix"})
public class FixGraphIdController {
    private static final Logger log = LoggerFactory.getLogger(FixGraphIdController.class);
    private static final String GRAPH_ID_PREFIX = "@GRAPH_ID@";
    private static final List<String> graphs = new ArrayList();
    private final BinaryElementSerializer serializer = BinaryElementSerializer.getInstance();
    @Autowired
    private HgStoreNodeService nodeService;

    public static byte[] getShortBytes(int x) {
        byte[] buf = new byte[]{(byte)(x >> 8), (byte)x};
        return buf;
    }

    @PutMapping(value={"/update_next_id/{partition_id}/{graph_id}"}, produces={"application/json"})
    public String updateMaxGraphId(@PathVariable(value="partition_id") int pid, @PathVariable(value="graph_id") long graphId) throws IOException {
        BusinessHandler businessHandler = this.nodeService.getStoreEngine().getBusinessHandler();
        try (GraphIdManager manager = new GraphIdManager((DBSessionBuilder)businessHandler, pid);){
            byte[] key = MetadataKeyHelper.getCidKey((String)"@GRAPH_ID@");
            log.info("update max graph id to {}, partition, {}", (Object)graphId, (Object)pid);
            manager.put(key, (GeneratedMessageV3)Int64Value.of((long)graphId));
            manager.flush();
        }
        return "OK";
    }

    @GetMapping(value={"/next_id/{partition_id}"}, produces={"application/json"})
    public String getNextId(@PathVariable(value="partition_id") int pid) throws IOException {
        BusinessHandlerImpl handler = (BusinessHandlerImpl)this.nodeService.getStoreEngine().getBusinessHandler();
        SessionOperator op = handler.getSession(pid).sessionOp();
        byte[] next = op.get("default", MetadataKeyHelper.getCidKey((String)"@GRAPH_ID@"));
        if (next != null) {
            return String.valueOf(Int64Value.parseFrom((byte[])next).getValue());
        }
        return "NOT_FOUND";
    }

    @PostMapping(value={"/update_graph_id/{partition_id}"}, produces={"application/json"})
    public String updateGraphId(@PathVariable(value="partition_id") int pid, @RequestBody Map<String, Long> idMap) throws IOException {
        BusinessHandlerImpl handler = (BusinessHandlerImpl)this.nodeService.getStoreEngine().getBusinessHandler();
        try (GraphIdManager manager = new GraphIdManager((DBSessionBuilder)handler, pid);){
            idMap.forEach((graphName, graphId) -> {
                log.info("update graph id of {} to {}, partition, {}", new Object[]{graphName, graphId, pid});
                byte[] graphIdKey = MetadataKeyHelper.getGraphIDKey((String)graphName);
                byte[] slotKey = manager.genCIDSlotKey("@GRAPH_ID@", graphId.longValue());
                Int64Value value = Int64Value.of((long)graphId);
                manager.put(graphIdKey, (GeneratedMessageV3)value);
                manager.put(slotKey, (GeneratedMessageV3)value);
            });
            manager.flush();
        }
        handler.getKeyCreator().clearCache(Integer.valueOf(pid));
        return "OK";
    }

    private Map.Entry<Map<Integer, Integer>, Map<Integer, List<RocksDBSession.BackendColumn>>> scanAndSample(SessionOperator op, String table) {
        HashMap<Integer, Integer> countMap = new HashMap<Integer, Integer>();
        HashMap sampleMap = new HashMap();
        Random random = new Random();
        try (ScanIterator iterator = op.scan(table);){
            while (iterator.hasNext()) {
                Integer count;
                RocksDBSession.BackendColumn col = (RocksDBSession.BackendColumn)iterator.next();
                if (col.name.length <= 2) continue;
                int id = (col.name[0] << 8) + col.name[1];
                if (!countMap.containsKey(id)) {
                    countMap.put(id, 0);
                    sampleMap.put(id, new ArrayList());
                }
                if ((count = countMap.put(id, (Integer)countMap.get(id) + 1)) == null) {
                    count = 0;
                }
                if (count < 100) {
                    ((List)sampleMap.get(id)).add(col);
                    continue;
                }
                int k = random.nextInt(count + 1);
                if (k >= 100) continue;
                ((List)sampleMap.get(id)).set(k, col);
            }
        }
        return new AbstractMap.SimpleEntry<Map<Integer, Integer>, Map<Integer, List<RocksDBSession.BackendColumn>>>(countMap, sampleMap);
    }

    private long getLabelId(RocksDBSession.BackendColumn col, String table) {
        BackendColumn newCol = BackendColumn.of((byte[])Arrays.copyOfRange(col.name, 2, col.name.length - 2), (byte[])col.value);
        Id id = this.serializer.parseLabelFromCol(newCol, Objects.equals("g+v", table));
        return id.asLong();
    }

    private Map<String, Object> scanAndSample(SessionOperator op, String table, byte[] start, byte[] end) {
        Random random = new Random();
        HashSet<Long> labels = new HashSet<Long>();
        try (ScanIterator iterator = op.scan(table, start, end, 16);){
            int count = 0;
            ArrayList<RocksDBSession.BackendColumn> sample = new ArrayList<RocksDBSession.BackendColumn>();
            while (iterator.hasNext()) {
                RocksDBSession.BackendColumn col = (RocksDBSession.BackendColumn)iterator.next();
                if (col.name.length <= 2) continue;
                if (count < 10000 || random.nextInt(100) == 1) {
                    labels.add(this.getLabelId(col, table));
                }
                if (count < 100) {
                    sample.add(col);
                } else {
                    int k = random.nextInt(count + 1);
                    if (k < 100) {
                        sample.set(k, col);
                    }
                }
                ++count;
            }
            Map<String, Object> map = Map.of("count", count, "sample", sample, "labels", labels.stream().map(String::valueOf).collect(Collectors.joining(",")));
            return map;
        }
    }

    private Map<Integer, Map<String, Object>> scanAndSample(RocksDBSession session) {
        HashMap<Integer, Map<String, Object>> result = new HashMap<Integer, Map<String, Object>>();
        SessionOperator op = session.sessionOp();
        for (int i = 0; i < 65536; ++i) {
            byte[] end;
            byte[] start = FixGraphIdController.getShortBytes((int)i);
            long size = session.getApproximateDataSize(start, end = FixGraphIdController.getShortBytes((int)(i + 1)));
            if (size <= 0L) continue;
            Map vMap = this.scanAndSample(op, "g+v", start, end);
            Map eMap = this.scanAndSample(op, "g+ie", start, end);
            if ((Integer)vMap.get("count") + (Integer)eMap.get("count") <= 0) continue;
            result.put(i, Map.of("vCount", vMap.get("count"), "eCount", eMap.get("count"), "size", size, "vLabels", vMap.get("labels"), "eLabels", eMap.get("labels"), "vSample", vMap.get("sample"), "eSample", eMap.get("sample")));
        }
        return result;
    }

    private String elementToString(BaseElement element) {
        if (element == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry property : element.getProperties().entrySet()) {
            BaseProperty value = (BaseProperty)property.getValue();
            Object v = ((BaseProperty)property.getValue()).value();
            if (!(v instanceof String)) continue;
            builder.append(value.propertyKey().name());
            builder.append(":").append(v).append(",");
        }
        return builder.toString();
    }

    private String runDeserialize(List<RocksDBSession.BackendColumn> list, boolean isVertex) {
        if (list == null || list.isEmpty()) {
            return "empty";
        }
        int total = list.size();
        StringBuilder buffer = new StringBuilder();
        for (String graph : graphs) {
            int success = 0;
            BaseElement element = null;
            for (RocksDBSession.BackendColumn column : list) {
                BackendColumn newCol = BackendColumn.of((byte[])Arrays.copyOfRange(column.name, 2, column.name.length - 2), (byte[])column.value);
                try {
                    element = QueryUtil.parseEntry((HugeGraphSupplier)BusinessHandlerImpl.getGraphSupplier((String)graph), (BackendColumn)newCol, (boolean)isVertex);
                    ++success;
                }
                catch (Exception e) {
                    log.warn("failed to parse column: {} for graph: {}", new Object[]{newCol, graph, e});
                }
            }
            if (!((double)success > (double)total * 0.8)) continue;
            buffer.append(String.format("%s: %f, %s\n", graph, (double)success * 1.0 / (double)total, element == null ? "FAIL" : element.toString()));
        }
        return buffer.toString();
    }

    private Map<String, String> runDeserialize(List<RocksDBSession.BackendColumn> list1, List<RocksDBSession.BackendColumn> list2) {
        int total1 = list1.size();
        int total2 = list2.size();
        ArrayList<String> passed = new ArrayList<String>();
        BaseElement element = null;
        BaseElement element2 = null;
        for (String graph : graphs) {
            BackendColumn newCol;
            int success = 0;
            int success2 = 0;
            for (RocksDBSession.BackendColumn column : list1) {
                newCol = BackendColumn.of((byte[])Arrays.copyOfRange(column.name, 2, column.name.length - 2), (byte[])column.value);
                try {
                    element = QueryUtil.parseEntry((HugeGraphSupplier)BusinessHandlerImpl.getGraphSupplier((String)graph), (BackendColumn)newCol, (boolean)true);
                    ++success;
                }
                catch (Exception e) {
                    log.warn("failed to parse entry: {}", (Object)newCol, (Object)e);
                }
            }
            if ((double)success < (double)total1 * 0.9) continue;
            for (RocksDBSession.BackendColumn column : list2) {
                newCol = BackendColumn.of((byte[])Arrays.copyOfRange(column.name, 2, column.name.length - 2), (byte[])column.value);
                try {
                    element2 = QueryUtil.parseEntry((HugeGraphSupplier)BusinessHandlerImpl.getGraphSupplier((String)graph), (BackendColumn)newCol, (boolean)false);
                    ++success2;
                }
                catch (Exception e) {
                    log.warn("failed to parse entry: {}", (Object)newCol, (Object)e);
                }
            }
            if (!((double)success2 >= (double)total2 * 0.9)) continue;
            passed.add(String.format("%s:%f", graph, (double)(success + success2) * 1.0 / (double)(total1 + total2)));
        }
        return Map.of("graphs", String.join((CharSequence)"\n", passed), "samples", String.join((CharSequence)"\n", List.of(this.elementToString(element), this.elementToString(element2))));
    }

    private Map<Integer, String> getGraphIds(RocksDBSession session) {
        HashMap<Integer, String> graphs;
        block10: {
            graphs = new HashMap<Integer, String>();
            SessionOperator op = session.sessionOp();
            byte[] prefix = MetadataKeyHelper.getGraphIDKey((String)"");
            ScanIterator iterator = op.scan("default", prefix);
            block7: while (true) {
                while (iterator.hasNext()) {
                    RocksDBSession.BackendColumn col = (RocksDBSession.BackendColumn)iterator.next();
                    try {
                        int graphId = (int)Int64Value.parseFrom((byte[])col.value).getValue();
                        String graphName = new String(col.name).replace("HUGEGRAPH/GRAPH_ID/", "");
                        graphs.put(graphId, graphName);
                        continue block7;
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.warn("failed to parse graphId: {}", (Object)col.value, (Object)e);
                    }
                }
                break block10;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
        }
        return graphs;
    }

    private Set<Integer> getSlotIds(RocksDBSession session) {
        HashSet<Integer> result;
        block10: {
            result = new HashSet<Integer>();
            SessionOperator op = session.sessionOp();
            byte[] prefix = MetadataKeyHelper.getCidSlotKeyPrefix((String)"@GRAPH_ID@");
            ScanIterator iterator = op.scan("default", prefix);
            block7: while (true) {
                while (iterator.hasNext()) {
                    RocksDBSession.BackendColumn col = (RocksDBSession.BackendColumn)iterator.next();
                    try {
                        int graphId = (int)Int64Value.parseFrom((byte[])col.value).getValue();
                        result.add(graphId);
                        continue block7;
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.warn("failed to parse graphId: {}", (Object)col.value, (Object)e);
                    }
                }
                break block10;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
        }
        return result;
    }

    @GetMapping(value={"/graph_ids/{id}"}, produces={"application/json"})
    public Map<Integer, Map<String, String>> allGraphIds(@PathVariable(value="id") int id) {
        RocksDBSession session = this.nodeService.getStoreEngine().getBusinessHandler().getSession(id);
        Map graphs = this.getGraphIds(session);
        Set slotIds = this.getSlotIds(session);
        HashMap<Integer, Map<String, String>> result = new HashMap<Integer, Map<String, String>>();
        for (int i = 0; i < 65536; ++i) {
            byte[] start = FixGraphIdController.getShortBytes((int)i);
            byte[] end = FixGraphIdController.getShortBytes((int)(i + 1));
            long size = session.getApproximateDataSize(start, end);
            long count = 0L;
            if (size > 0L && size < 512L && (count = session.sessionOp().keyCount(start, end, "g+v")) == 0L || size <= 0L && !graphs.containsKey(i)) continue;
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put("size", String.valueOf(size));
            tmp.put("graph", graphs.getOrDefault(i, "not found"));
            if (count > 0L) {
                tmp.put("count", String.valueOf(count));
            }
            if (slotIds.contains(i)) {
                tmp.put("has_slot_id", "true");
            }
            result.put(i, tmp);
        }
        return result;
    }

    @GetMapping(value={"/check/{id}"}, produces={"application/json"})
    public Map<Integer, Map<String, String>> checkGraphId(@PathVariable(value="id") int id) {
        BusinessHandler businessHandler = this.nodeService.getStoreEngine().getBusinessHandler();
        RocksDBSession session = businessHandler.getSession(id);
        Map graphs = this.getGraphIds(session);
        HashMap<Integer, Map<String, String>> result = new HashMap<Integer, Map<String, String>>();
        Map samples = this.scanAndSample(session);
        for (Map.Entry entry : samples.entrySet()) {
            Integer graphId = (Integer)entry.getKey();
            Map value = (Map)entry.getValue();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("size", String.valueOf(value.get("size")));
            map.put("vertex count", String.valueOf(value.get("vCount")));
            map.put("in edge count", String.valueOf(value.get("eCount")));
            map.put("graph id", graphs.getOrDefault(graphId, "not found"));
            map.put("vLabels", String.valueOf(value.get("vLabels")));
            map.put("eLabels", String.valueOf(value.get("eLabels")));
            List list1 = (List)value.get("vSample");
            List list2 = (List)value.get("eSample");
            Map parseResult = this.runDeserialize(list1, list2);
            map.put("graphs", parseResult.getOrDefault("graphs", ""));
            map.put("samples", parseResult.getOrDefault("samples", ""));
            result.put(graphId, map);
        }
        return result;
    }

    @GetMapping(value={"/delete_graph_id/{partition}/{graph_id}"}, produces={"application/json"})
    public String deleteGraphId(@PathVariable(value="partition") int pid, @PathVariable(value="graph_id") int gid) {
        byte[] start = FixGraphIdController.getShortBytes((int)gid);
        byte[] end = Arrays.copyOf(start, start.length);
        SessionOperatorImpl.increaseOne((byte[])end);
        BusinessHandler businessHandler = this.nodeService.getStoreEngine().getBusinessHandler();
        SessionOperator op = businessHandler.getSession(pid).sessionOp();
        List<String> tables = List.of("g+v", "g+ie", "g+oe", "g+index", "g+olap");
        for (String table : tables) {
            op.deleteRange(table, start, end);
        }
        op.commit();
        return "OK";
    }

    @GetMapping(value={"/clean/{graph:.+}"}, produces={"application/json"})
    public String cleanGraph(@PathVariable(value="graph") String graph) {
        BusinessHandler businessHandler = this.nodeService.getStoreEngine().getBusinessHandler();
        List<String> tables = List.of("g+v", "g+ie", "g+oe");
        InnerKeyCreator keyCreator = new InnerKeyCreator(businessHandler);
        HugeGraphSupplier supplier = BusinessHandlerImpl.getGraphSupplier((String)graph);
        List partitions = businessHandler.getPartitionIds(graph);
        for (Integer pid : partitions) {
            RocksDBSession session = businessHandler.getSession(pid.intValue());
            SessionOperator op = session.sessionOp();
            block8: for (String table : tables) {
                boolean isVertex = QueryUtil.isVertex((String)table);
                ScanIterator itr = op.scan(table, keyCreator.getStartKey(pid, graph), keyCreator.getEndKey(pid, graph), 0);
                block9: while (true) {
                    while (itr.hasNext()) {
                        RocksDBSession.BackendColumn col = (RocksDBSession.BackendColumn)itr.next();
                        BackendColumn newCol = BackendColumn.of((byte[])Arrays.copyOfRange(col.name, 2, col.name.length - 2), (byte[])col.value);
                        try {
                            QueryUtil.parseEntry((HugeGraphSupplier)supplier, (BackendColumn)newCol, (boolean)isVertex);
                            continue block9;
                        }
                        catch (Exception e) {
                            op.delete(table, col.name);
                        }
                    }
                    continue block8;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    if (itr == null) continue;
                    itr.close();
                }
            }
            op.commit();
        }
        return "OK";
    }
}

