/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.store.business.BusinessHandler;
import org.apache.hugegraph.store.business.FilterIterator;
import org.apache.hugegraph.store.grpc.common.GraphMethod;
import org.apache.hugegraph.store.grpc.common.TableMethod;
import org.apache.hugegraph.store.grpc.session.BatchEntry;
import org.apache.hugegraph.store.node.grpc.HgStoreWrapperEx;
import org.apache.hugegraph.store.term.HgPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HgStoreWrapperEx {
    private static final Logger log = LoggerFactory.getLogger(HgStoreWrapperEx.class);
    private final BusinessHandler handler;

    public HgStoreWrapperEx(BusinessHandler handler) {
        this.handler = handler;
    }

    public byte[] doGet(String graph, int code, String table, byte[] key) {
        return this.handler.doGet(graph, code, table, key);
    }

    public boolean doClean(String graph, int partId) {
        return this.handler.cleanPartition(graph, partId);
    }

    public ScanIterator scanAll(String graph, String table, byte[] query) {
        ScanIterator scanIterator = this.handler.scanAll(graph, table, query);
        return FilterIterator.of((ScanIterator)scanIterator, (byte[])query);
    }

    public ScanIterator scan(String graph, int partId, String table, byte[] start, byte[] end, int scanType, byte[] query) {
        ScanIterator scanIterator = this.handler.scan(graph, partId, table, start, end, scanType, query);
        return FilterIterator.of((ScanIterator)scanIterator, (byte[])query);
    }

    public void batchGet(String graph, String table, Supplier<HgPair<Integer, byte[]>> s, Consumer<HgPair<byte[], byte[]>> c) {
        this.handler.batchGet(graph, table, s, pair -> c.accept(new HgPair((Object)((byte[])pair.getKey()), (Object)((byte[])pair.getValue()))));
    }

    public ScanIterator scanPrefix(String graph, int partition, String table, byte[] prefix, int scanType, byte[] query) {
        ScanIterator scanIterator = this.handler.scanPrefix(graph, partition, table, prefix, scanType);
        return FilterIterator.of((ScanIterator)scanIterator, (byte[])query);
    }

    public void doBatch(String graph, int partId, List<BatchEntry> entryList) {
        this.handler.doBatch(graph, partId, entryList);
    }

    public boolean doTable(int partId, TableMethod method, String graph, String table) {
        boolean flag;
        switch (1.$SwitchMap$org$apache$hugegraph$store$grpc$common$TableMethod[method.ordinal()]) {
            case 1: {
                flag = this.handler.existsTable(graph, partId, table);
                break;
            }
            case 2: {
                this.handler.createTable(graph, partId, table);
                flag = true;
                break;
            }
            case 3: {
                this.handler.deleteTable(graph, partId, table);
                flag = true;
                break;
            }
            case 4: {
                this.handler.dropTable(graph, partId, table);
                flag = true;
                break;
            }
            case 5: {
                this.handler.truncate(graph, partId);
                flag = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException("TableMethod: " + method.name());
            }
        }
        return flag;
    }

    public boolean doGraph(int partId, GraphMethod method, String graph) {
        boolean flag = true;
        if (method != GraphMethod.GRAPH_METHOD_DELETE) {
            throw new UnsupportedOperationException("GraphMethod: " + method.name());
        }
        flag = true;
        return flag;
    }
}

