/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.jianfan;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.nlpcn.commons.lang.tire.GetWord;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.tire.domain.Value;
import org.nlpcn.commons.lang.tire.library.Library;
import org.nlpcn.commons.lang.util.StringUtil;

public enum Converter {
    SIMPLIFIED(false),
    TRADITIONAL(true);

    public static final char CJK_UNIFIED_IDEOGRAPHS_START = '\u4e00';
    public static final char CJK_UNIFIED_IDEOGRAPHS_END = '\u9fa5';
    public static final String SIMPLIFIED_MAPPING_FILE = "/simp.txt";
    public static final String SIMPLIFIED_LEXEMIC_MAPPING_FILE = "/simplified.txt";
    public static final String TRADITIONAL_MAPPING_FILE = "/trad.txt";
    public static final String TRADITIONAL_LEXEMIC_MAPPING_FILE = "/traditional.txt";
    public static final String EMPTY = "";
    public static final String SHARP = "#";
    public static final String EQUAL = "=";
    private char[] chars = null;
    private Forest dict = null;
    private int maxLen = 2;

    private Converter(boolean s2t) {
        this.loadCharMapping(s2t);
        this.loadLexemicMapping(s2t);
    }

    public void loadCharMapping(boolean s2t) {
        String mappingFile = SIMPLIFIED_MAPPING_FILE;
        if (s2t) {
            mappingFile = TRADITIONAL_MAPPING_FILE;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(((Object)((Object)this)).getClass().getResourceAsStream(mappingFile)), StandardCharsets.UTF_8));
            CharArrayWriter out = new CharArrayWriter();
            String line = null;
            while (null != (line = in.readLine())) {
                out.write(line);
            }
            this.chars = out.toCharArray();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadLexemicMapping(boolean s2t) {
        String mappingFile = SIMPLIFIED_LEXEMIC_MAPPING_FILE;
        if (s2t) {
            mappingFile = TRADITIONAL_LEXEMIC_MAPPING_FILE;
        }
        this.dict = new Forest();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(((Object)((Object)this)).getClass().getResourceAsStream(mappingFile)), StandardCharsets.UTF_8));
            String line = null;
            while (null != (line = in.readLine())) {
                String[] pair;
                if (line.length() == 0 || line.startsWith(SHARP) || (pair = line.split(EQUAL)).length < 2) continue;
                this.maxLen = this.maxLen < pair[0].length() ? pair[0].length() : this.maxLen;
                Library.insertWord(this.dict, new Value(pair[0], pair[1]));
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public char convert(char ch) {
        if (ch >= '\u4e00' && ch <= '\u9fa5') {
            return this.chars[ch - 19968];
        }
        return ch;
    }

    private void strConvert(String str, StringBuilder sb) {
        if (StringUtil.isBlank(str)) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            sb.append(this.convert(str.charAt(i)));
        }
    }

    public String convert(String str) {
        if (StringUtil.isBlank(str)) {
            return str;
        }
        GetWord word = this.dict.getWord(str);
        StringBuilder sb = new StringBuilder(str.length());
        String temp = null;
        int beginOffe = 0;
        while ((temp = word.getFrontWords()) != null) {
            this.strConvert(str.substring(beginOffe, word.offe), sb);
            sb.append(word.getParam(0));
            beginOffe = word.offe + temp.length();
        }
        if (beginOffe < str.length()) {
            this.strConvert(str.substring(beginOffe, str.length()), sb);
        }
        return sb.toString();
    }
}

