/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.gremlin;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.apache.hugegraph.util.ExecutorUtil;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.message.GZipEncoder;

public abstract class AbstractJerseyRestClient {
    private static final long TTL = 24L;
    private static final long IDLE_TIME = 40000L;
    private static final String PROPERTY_MAX_TOTAL = "maxTotal";
    private static final String PROPERTY_MAX_PER_ROUTE = "maxPerRoute";
    private static final String PROPERTY_IDLE_TIME = "idleTime";
    private static final String CONNECTION_MANAGER = "jersey.config.apache.client.connectionManager";
    private final Client client;
    private final WebTarget webTarget;
    private final PoolingHttpClientConnectionManager pool;
    private ScheduledExecutorService cleanExecutor;

    public AbstractJerseyRestClient(String url, int timeout, int maxTotal, int maxPerRoute) {
        this(url, new ConfigBuilder().configTimeout(timeout).configPool(maxTotal, maxPerRoute).build());
    }

    public AbstractJerseyRestClient(String url, ClientConfig config) {
        this.pool = AbstractJerseyRestClient.configConnectionManager(config);
        this.client = JerseyClientBuilder.newClient((Configuration)config);
        this.client.register(GZipEncoder.class);
        this.webTarget = this.client.target(url);
        this.cleanThreadPoolExecutor(config);
    }

    private static PoolingHttpClientConnectionManager configConnectionManager(ClientConfig conf) {
        PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager(24L, TimeUnit.HOURS);
        Integer maxTotal = (Integer)conf.getProperty(PROPERTY_MAX_TOTAL);
        Integer maxPerRoute = (Integer)conf.getProperty(PROPERTY_MAX_PER_ROUTE);
        if (maxTotal != null) {
            pool.setMaxTotal(maxTotal.intValue());
        }
        if (maxPerRoute != null) {
            pool.setDefaultMaxPerRoute(maxPerRoute.intValue());
        }
        conf.property(CONNECTION_MANAGER, (Object)pool);
        conf.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        return pool;
    }

    private void cleanThreadPoolExecutor(ClientConfig config) {
        this.cleanExecutor = ExecutorUtil.newScheduledThreadPool((String)"conn-clean-worker-%d");
        Number idleTimeProp = (Number)config.getProperty(PROPERTY_IDLE_TIME);
        long idleTime = idleTimeProp == null ? 40000L : idleTimeProp.longValue();
        long checkPeriod = idleTime / 2L;
        this.cleanExecutor.scheduleWithFixedDelay(() -> {
            PoolStats stats = this.pool.getTotalStats();
            int using = stats.getLeased() + stats.getPending();
            if (using > 0) {
                return;
            }
            this.pool.closeIdleConnections(idleTime, TimeUnit.MILLISECONDS);
            this.pool.closeExpiredConnections();
        }, checkPeriod, checkPeriod, TimeUnit.MILLISECONDS);
    }

    protected WebTarget getWebTarget() {
        return this.webTarget;
    }

    public void close() {
        try {
            if (this.pool != null) {
                this.pool.close();
                this.cleanExecutor.shutdownNow();
            }
        }
        finally {
            this.client.close();
        }
    }

    private static class ConfigBuilder {
        private final ClientConfig config = new ClientConfig();

        ConfigBuilder() {
        }

        public ConfigBuilder configTimeout(int timeout) {
            this.config.property("jersey.config.client.connectTimeout", (Object)timeout);
            this.config.property("jersey.config.client.readTimeout", (Object)timeout);
            return this;
        }

        public ConfigBuilder configPool(int maxTotal, int maxPerRoute) {
            this.config.property(AbstractJerseyRestClient.PROPERTY_MAX_TOTAL, (Object)maxTotal);
            this.config.property(AbstractJerseyRestClient.PROPERTY_MAX_PER_ROUTE, (Object)maxPerRoute);
            return this;
        }

        public ClientConfig build() {
            return this.config;
        }
    }
}

