/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apdplat.word.analysis.TextSimilarity;
import org.apdplat.word.segmentation.Word;

public class JaccardTextSimilarity
extends TextSimilarity {
    @Override
    protected double scoreImpl(List<Word> list, List<Word> list2) {
        if (list.isEmpty() && list2.isEmpty()) {
            return 1.0;
        }
        HashSet<Word> hashSet = new HashSet<Word>();
        hashSet.addAll(list2);
        ConcurrentSkipListSet concurrentSkipListSet = new ConcurrentSkipListSet();
        list.parallelStream().forEach(word -> {
            if (hashSet.contains(word)) {
                concurrentSkipListSet.add(word.getText());
            }
        });
        int n = concurrentSkipListSet.size();
        HashSet hashSet2 = new HashSet();
        list.forEach(word -> hashSet2.add(word.getText()));
        list2.forEach(word -> hashSet2.add(word.getText()));
        int n2 = hashSet2.size();
        double d = (double)n / (double)n2;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u4ea4\u96c6\u7684\u5927\u5c0f\uff1a" + n);
            LOGGER.debug("\u5e76\u96c6\u7684\u5927\u5c0f\uff1a" + n2);
            LOGGER.debug("\u76f8\u4f3c\u5ea6\u5206\u503c=" + n + "/(double)" + n2 + "=" + d);
        }
        return d;
    }

    public static void main(String[] stringArray) {
        String string = "\u6211\u7231\u8d2d\u7269";
        String string2 = "\u6211\u7231\u8bfb\u4e66";
        String string3 = "\u4ed6\u662f\u9ed1\u5ba2";
        JaccardTextSimilarity jaccardTextSimilarity = new JaccardTextSimilarity();
        double d = jaccardTextSimilarity.similarScore(string, string);
        double d2 = jaccardTextSimilarity.similarScore(string, string2);
        double d3 = jaccardTextSimilarity.similarScore(string, string3);
        double d4 = jaccardTextSimilarity.similarScore(string2, string2);
        double d5 = jaccardTextSimilarity.similarScore(string2, string3);
        double d6 = jaccardTextSimilarity.similarScore(string3, string3);
        System.out.println(string + " \u548c " + string + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d);
        System.out.println(string + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d2);
        System.out.println(string + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d3);
        System.out.println(string2 + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d4);
        System.out.println(string2 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d5);
        System.out.println(string3 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d6);
    }
}

