/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apdplat.word.recognition.RecognitionTool;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.segmentation.impl.AbstractSegmentation;

public class ReverseMaximumMatching
extends AbstractSegmentation {
    @Override
    public SegmentationAlgorithm getSegmentationAlgorithm() {
        return SegmentationAlgorithm.ReverseMaximumMatching;
    }

    @Override
    public List<Word> segImpl(String string) {
        int n;
        Stack<Word> stack = new Stack<Word>();
        int n2 = string.length();
        int n3 = n2 - (n = this.getInterceptLength());
        if (n3 < 0) {
            n3 = 0;
        }
        if (n > n2 - n3) {
            n = n2 - n3;
        }
        while (n3 >= 0 && n > 0) {
            while (!this.getDictionary().contains(string, n3, n) && !RecognitionTool.recog(string, n3, n) && n != 1) {
                --n;
                ++n3;
            }
            this.addWord(stack, string, n3, n);
            n = this.getInterceptLength();
            if (n > n3) {
                n = n3;
            }
            n3 -= n;
        }
        n = stack.size();
        ArrayList<Word> arrayList = new ArrayList<Word>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(stack.pop());
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        String string = "'\u8f6f\u4ef6\u5de5\u7a0b\u56db\u5927\u5723\u7ecf'\uff1a\u300a\u8bbe\u8ba1\u6a21\u5f0f\u300b\u3001\u300a\u53cd\u6a21\u5f0f\u300b\u3001\u300a\u91cd\u6784\u300b\u3001\u300a\u89e3\u6790\u6781\u9650\u7f16\u7a0b\u300b\u3002\u5176\u4e2d\u300a\u8bbe\u8ba1\u6a21\u5f0f\u300b\u548c\u300a\u91cd\u6784\u300b\u53f7\u79f0'\u8f6f\u5de5\u53cc\u96c4'\u3002";
        if (stringArray != null && stringArray.length == 1) {
            string = stringArray[0];
        }
        ReverseMaximumMatching reverseMaximumMatching = new ReverseMaximumMatching();
        System.out.println(reverseMaximumMatching.seg(string).toString());
    }
}

