/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.Cluster;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.log.LogCodes;

public class ClusterFactory {
    public static Cluster getCluster(ConsumerBootstrap consumerBootstrap) {
        String cluster = null;
        try {
            ConsumerConfig consumerConfig = consumerBootstrap.getConsumerConfig();
            cluster = consumerConfig.getCluster();
            ExtensionClass<Cluster> ext = ExtensionLoaderFactory.getExtensionLoader(Cluster.class).getExtensionClass(cluster);
            if (ext == null) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("020010007", cluster));
            }
            return ext.getExtInstance(new Class[]{ConsumerBootstrap.class}, new Object[]{consumerBootstrap});
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("020010007", cluster), e);
        }
    }
}

