/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.dynamic;

import com.alipay.sofa.rpc.common.utils.StringUtils;

public class DynamicConfigKeyHelper {
    private static final String KEY_SEPARATOR = ".";
    public static final String APP_CONSUMER_CONFIG_KEY_PREFIX = "sofa.consumer";
    public static final String APP_PROVIDER_CONFIG_KEY_PREFIX = "sofa.provider";
    public static final String SERVICE_CONSUMER_PROPERTY_KEY_PREFIX = "sofa.consumer.service";
    public static final String SERVICE_PROVIDER_PROPERTY_KEY_PREFIX = "sofa.provider.service";
    public static final String METHOD_CONSUMER_PROPERTY_KEY_PREFIX = "sofa.consumer.method";
    public static final String METHOD_PROVIDER_PROPERTY_KEY_PREFIX = "sofa.provider.method";

    public static String extractPropertyKey(String key) {
        if (StringUtils.isBlank(key)) {
            return "";
        }
        return key.substring(key.lastIndexOf(KEY_SEPARATOR) + 1);
    }

    public static String extractServiceNameFromServiceProKey(String serviceProKey) {
        if (!DynamicConfigKeyHelper.isServiceProKey(serviceProKey)) {
            return "";
        }
        return serviceProKey.substring(SERVICE_CONSUMER_PROPERTY_KEY_PREFIX.length() + 1, serviceProKey.lastIndexOf(KEY_SEPARATOR));
    }

    public static String extractServiceNameFromMethodProKey(String methodProKey) {
        if (!DynamicConfigKeyHelper.isMethodProKey(methodProKey)) {
            return "";
        }
        String serviceMethod = methodProKey.substring(METHOD_PROVIDER_PROPERTY_KEY_PREFIX.length() + 1, methodProKey.lastIndexOf(KEY_SEPARATOR));
        return serviceMethod.substring(0, serviceMethod.lastIndexOf(KEY_SEPARATOR));
    }

    public static String extractMethodNameFromMethodProKey(String methodProKey) {
        if (!DynamicConfigKeyHelper.isMethodProKey(methodProKey)) {
            return "";
        }
        String serviceMethod = methodProKey.substring(METHOD_PROVIDER_PROPERTY_KEY_PREFIX.length() + 1, methodProKey.lastIndexOf(KEY_SEPARATOR));
        return serviceMethod.substring(serviceMethod.lastIndexOf(KEY_SEPARATOR) + 1);
    }

    public static String buildConsumerServiceProKey(String serviceName, String proKey) {
        return "sofa.consumer.service." + serviceName + KEY_SEPARATOR + proKey;
    }

    public static String buildProviderServiceProKey(String serviceName, String proKey) {
        return "sofa.provider.service." + serviceName + KEY_SEPARATOR + proKey;
    }

    public static String buildConsumerMethodProKey(String serviceName, String methodName, String proKey) {
        return "sofa.consumer.method." + serviceName + KEY_SEPARATOR + methodName + KEY_SEPARATOR + proKey;
    }

    public static String buildProviderMethodProKey(String serviceName, String methodName, String proKey) {
        return "sofa.provider.method." + serviceName + KEY_SEPARATOR + methodName + KEY_SEPARATOR + proKey;
    }

    public static boolean isServiceProKey(String key) {
        return !StringUtils.isBlank(key) && (key.startsWith(SERVICE_CONSUMER_PROPERTY_KEY_PREFIX) || key.startsWith(SERVICE_PROVIDER_PROPERTY_KEY_PREFIX));
    }

    public static boolean isMethodProKey(String key) {
        return !StringUtils.isBlank(key) && (key.startsWith(METHOD_CONSUMER_PROPERTY_KEY_PREFIX) || key.startsWith(METHOD_PROVIDER_PROPERTY_KEY_PREFIX));
    }

    public static boolean isSofaProKey(String key) {
        return DynamicConfigKeyHelper.isServiceProKey(key) || DynamicConfigKeyHelper.isMethodProKey(key);
    }
}

