/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import io.netty.channel.Channel;
import java.io.IOException;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.net.OutboundConnectionSettings;
import org.apache.cassandra.streaming.DefaultConnectionFactory;
import org.apache.cassandra.streaming.StreamConnectionFactory;

public class BulkLoadConnectionFactory
extends DefaultConnectionFactory
implements StreamConnectionFactory {
    private final int storagePort;
    private final EncryptionOptions.ServerEncryptionOptions encryptionOptions;

    public BulkLoadConnectionFactory(EncryptionOptions.ServerEncryptionOptions encryptionOptions, int storagePort) {
        this.storagePort = storagePort;
        this.encryptionOptions = encryptionOptions;
    }

    @Override
    public Channel createConnection(OutboundConnectionSettings template, int messagingVersion) throws IOException {
        template = template.withConnectTo(template.to.withPort(this.storagePort));
        if (this.encryptionOptions != null && this.encryptionOptions.internode_encryption != EncryptionOptions.ServerEncryptionOptions.InternodeEncryption.none) {
            template = template.withEncryption(this.encryptionOptions);
        }
        return super.createConnection(template, messagingVersion);
    }

    @Override
    public boolean supportsPreferredIp() {
        return false;
    }
}

