/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.WorkflowApproverApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.workflow.ApproverPageRequest;
import org.apache.inlong.manager.pojo.workflow.ApproverRequest;
import org.apache.inlong.manager.pojo.workflow.ApproverResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowApproverClient {
    private static final Logger log = LoggerFactory.getLogger(WorkflowApproverClient.class);
    private final WorkflowApproverApi workflowApproverApi;

    public WorkflowApproverClient(ClientConfiguration configuration) {
        this.workflowApproverApi = (WorkflowApproverApi)ClientUtils.createRetrofit(configuration).create(WorkflowApproverApi.class);
    }

    public Integer save(ApproverRequest request) {
        Preconditions.expectNotBlank((String)request.getProcessName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"process name cannot be empty");
        Preconditions.expectNotBlank((String)request.getTaskName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"task name cannot be empty");
        Preconditions.expectNotBlank((String)request.getApprovers(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"approvers cannot be empty");
        Response<Integer> response = ClientUtils.executeHttpCall(this.workflowApproverApi.save(request));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public ApproverResponse get(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"id cannot be null");
        Response<ApproverResponse> response = ClientUtils.executeHttpCall(this.workflowApproverApi.get(id));
        ClientUtils.assertRespSuccess(response);
        return (ApproverResponse)response.getData();
    }

    public List<ApproverResponse> listByCondition(ApproverPageRequest request) {
        Preconditions.expectNotNull((Object)request.getPageNum(), (String)"page num cannot be null");
        Preconditions.expectNotNull((Object)request.getPageSize(), (String)"page size cannot be null");
        Map requestMap = (Map)JsonUtils.OBJECT_MAPPER.convertValue((Object)request, (TypeReference)new TypeReference<Map<String, Object>>(){});
        requestMap.entrySet().removeIf(entry -> Objects.isNull(entry.getValue()));
        Response<PageResult<ApproverResponse>> response = ClientUtils.executeHttpCall(this.workflowApproverApi.listByCondition(requestMap));
        ClientUtils.assertRespSuccess(response);
        return ((PageResult)response.getData()).getList();
    }

    public Boolean delete(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"id cannot be null");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.workflowApproverApi.delete(id));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Integer update(ApproverRequest request) {
        Preconditions.expectNotNull((Object)request.getId(), (String)"id cannot be null");
        Response<Integer> response = ClientUtils.executeHttpCall(this.workflowApproverApi.update(request));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }
}

