/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.LongValues;

abstract class GlobalOrdinalsWithScoreCollector
implements Collector {
    final String field;
    final boolean doMinMax;
    final int min;
    final int max;
    final OrdinalMap ordinalMap;
    final LongBitSet collectedOrds;
    protected final Scores scores;
    protected final Occurrences occurrences;
    static final int arraySize = 4096;

    GlobalOrdinalsWithScoreCollector(String field, OrdinalMap ordinalMap, long valueCount, ScoreMode scoreMode, int min, int max) {
        if (valueCount > Integer.MAX_VALUE) {
            throw new IllegalStateException("Can't collect more than [2147483647] ids");
        }
        this.field = field;
        this.doMinMax = min > 0 || max != Integer.MAX_VALUE;
        this.min = min;
        this.max = max;
        this.ordinalMap = ordinalMap;
        this.collectedOrds = new LongBitSet(valueCount);
        this.scores = scoreMode != ScoreMode.None ? new Scores(valueCount, this.unset()) : null;
        this.occurrences = scoreMode == ScoreMode.Avg || this.doMinMax ? new Occurrences(valueCount) : null;
    }

    public boolean match(int globalOrd) {
        if (this.collectedOrds.get((long)globalOrd)) {
            if (this.doMinMax) {
                int occurrence = this.occurrences.getOccurrence(globalOrd);
                return occurrence >= this.min && occurrence <= this.max;
            }
            return true;
        }
        return false;
    }

    public float score(int globalOrdinal) {
        return this.scores.getScore(globalOrdinal);
    }

    protected abstract void doScore(int var1, float var2, float var3);

    protected abstract float unset();

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        SortedDocValues docTermOrds = DocValues.getSorted((LeafReader)context.reader(), (String)this.field);
        if (this.ordinalMap != null) {
            LongValues segmentOrdToGlobalOrdLookup = this.ordinalMap.getGlobalOrds(context.ord);
            return new OrdinalMapCollector(docTermOrds, segmentOrdToGlobalOrdLookup);
        }
        return new SegmentOrdinalCollector(docTermOrds);
    }

    public boolean needsScores() {
        return true;
    }

    static final class Occurrences {
        final int[][] blocks;

        private Occurrences(long valueCount) {
            long blockSize = valueCount + 4096L - 1L;
            this.blocks = new int[(int)(blockSize / 4096L)][];
        }

        public void increment(int globalOrdinal) {
            int block = globalOrdinal / 4096;
            int offset = globalOrdinal % 4096;
            int[] occurrences = this.blocks[block];
            if (occurrences == null) {
                occurrences = new int[4096];
                this.blocks[block] = occurrences;
            }
            int n = offset;
            occurrences[n] = occurrences[n] + 1;
        }

        public int getOccurrence(int globalOrdinal) {
            int block = globalOrdinal / 4096;
            int offset = globalOrdinal % 4096;
            int[] occurrences = this.blocks[block];
            return occurrences[offset];
        }
    }

    static final class Scores {
        final float[][] blocks;
        final float unset;

        private Scores(long valueCount, float unset) {
            long blockSize = valueCount + 4096L - 1L;
            this.blocks = new float[(int)(blockSize / 4096L)][];
            this.unset = unset;
        }

        public void setScore(int globalOrdinal, float score) {
            int block = globalOrdinal / 4096;
            int offset = globalOrdinal % 4096;
            float[] scores = this.blocks[block];
            if (scores == null) {
                scores = new float[4096];
                this.blocks[block] = scores;
                if (this.unset != 0.0f) {
                    Arrays.fill(scores, this.unset);
                }
            }
            scores[offset] = score;
        }

        public float getScore(int globalOrdinal) {
            int block = globalOrdinal / 4096;
            int offset = globalOrdinal % 4096;
            float[] scores = this.blocks[block];
            float score = scores != null ? scores[offset] : this.unset;
            return score;
        }
    }

    static final class NoScore
    extends GlobalOrdinalsWithScoreCollector {
        public NoScore(String field, OrdinalMap ordinalMap, long valueCount, int min, int max) {
            super(field, ordinalMap, valueCount, ScoreMode.None, min, max);
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            final SortedDocValues docTermOrds = DocValues.getSorted((LeafReader)context.reader(), (String)this.field);
            if (this.ordinalMap != null) {
                final LongValues segmentOrdToGlobalOrdLookup = this.ordinalMap.getGlobalOrds(context.ord);
                return new LeafCollector(){

                    public void setScorer(Scorer scorer) throws IOException {
                    }

                    public void collect(int doc) throws IOException {
                        if (docTermOrds.advanceExact(doc)) {
                            int globalOrd = (int)segmentOrdToGlobalOrdLookup.get((long)docTermOrds.ordValue());
                            collectedOrds.set((long)globalOrd);
                            occurrences.increment(globalOrd);
                        }
                    }
                };
            }
            return new LeafCollector(){

                public void setScorer(Scorer scorer) throws IOException {
                }

                public void collect(int doc) throws IOException {
                    if (docTermOrds.advanceExact(doc)) {
                        int segmentOrd = docTermOrds.ordValue();
                        collectedOrds.set((long)segmentOrd);
                        occurrences.increment(segmentOrd);
                    }
                }
            };
        }

        @Override
        protected void doScore(int globalOrd, float existingScore, float newScore) {
        }

        @Override
        public float score(int globalOrdinal) {
            return 1.0f;
        }

        @Override
        protected float unset() {
            return 0.0f;
        }

        @Override
        public boolean needsScores() {
            return false;
        }
    }

    static final class Avg
    extends GlobalOrdinalsWithScoreCollector {
        public Avg(String field, OrdinalMap ordinalMap, long valueCount, int min, int max) {
            super(field, ordinalMap, valueCount, ScoreMode.Avg, min, max);
        }

        @Override
        protected void doScore(int globalOrd, float existingScore, float newScore) {
            this.scores.setScore(globalOrd, existingScore + newScore);
        }

        @Override
        public float score(int globalOrdinal) {
            return this.scores.getScore(globalOrdinal) / (float)this.occurrences.getOccurrence(globalOrdinal);
        }

        @Override
        protected float unset() {
            return 0.0f;
        }
    }

    static final class Sum
    extends GlobalOrdinalsWithScoreCollector {
        public Sum(String field, OrdinalMap ordinalMap, long valueCount, int min, int max) {
            super(field, ordinalMap, valueCount, ScoreMode.Total, min, max);
        }

        @Override
        protected void doScore(int globalOrd, float existingScore, float newScore) {
            this.scores.setScore(globalOrd, existingScore + newScore);
        }

        @Override
        protected float unset() {
            return 0.0f;
        }
    }

    static final class Max
    extends GlobalOrdinalsWithScoreCollector {
        public Max(String field, OrdinalMap ordinalMap, long valueCount, int min, int max) {
            super(field, ordinalMap, valueCount, ScoreMode.Max, min, max);
        }

        @Override
        protected void doScore(int globalOrd, float existingScore, float newScore) {
            this.scores.setScore(globalOrd, Math.max(existingScore, newScore));
        }

        @Override
        protected float unset() {
            return Float.NEGATIVE_INFINITY;
        }
    }

    static final class Min
    extends GlobalOrdinalsWithScoreCollector {
        public Min(String field, OrdinalMap ordinalMap, long valueCount, int min, int max) {
            super(field, ordinalMap, valueCount, ScoreMode.Min, min, max);
        }

        @Override
        protected void doScore(int globalOrd, float existingScore, float newScore) {
            this.scores.setScore(globalOrd, Math.min(existingScore, newScore));
        }

        @Override
        protected float unset() {
            return Float.POSITIVE_INFINITY;
        }
    }

    final class SegmentOrdinalCollector
    implements LeafCollector {
        private final SortedDocValues docTermOrds;
        private Scorer scorer;

        SegmentOrdinalCollector(SortedDocValues docTermOrds) {
            this.docTermOrds = docTermOrds;
        }

        public void collect(int doc) throws IOException {
            if (this.docTermOrds.advanceExact(doc)) {
                int segmentOrd = this.docTermOrds.ordValue();
                GlobalOrdinalsWithScoreCollector.this.collectedOrds.set((long)segmentOrd);
                float existingScore = GlobalOrdinalsWithScoreCollector.this.scores.getScore(segmentOrd);
                float newScore = this.scorer.score();
                GlobalOrdinalsWithScoreCollector.this.doScore(segmentOrd, existingScore, newScore);
                if (GlobalOrdinalsWithScoreCollector.this.occurrences != null) {
                    GlobalOrdinalsWithScoreCollector.this.occurrences.increment(segmentOrd);
                }
            }
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }
    }

    final class OrdinalMapCollector
    implements LeafCollector {
        private final SortedDocValues docTermOrds;
        private final LongValues segmentOrdToGlobalOrdLookup;
        private Scorer scorer;

        OrdinalMapCollector(SortedDocValues docTermOrds, LongValues segmentOrdToGlobalOrdLookup) {
            this.docTermOrds = docTermOrds;
            this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
        }

        public void collect(int doc) throws IOException {
            if (this.docTermOrds.advanceExact(doc)) {
                int globalOrd = (int)this.segmentOrdToGlobalOrdLookup.get((long)this.docTermOrds.ordValue());
                GlobalOrdinalsWithScoreCollector.this.collectedOrds.set((long)globalOrd);
                float existingScore = GlobalOrdinalsWithScoreCollector.this.scores.getScore(globalOrd);
                float newScore = this.scorer.score();
                GlobalOrdinalsWithScoreCollector.this.doScore(globalOrd, existingScore, newScore);
                if (GlobalOrdinalsWithScoreCollector.this.occurrences != null) {
                    GlobalOrdinalsWithScoreCollector.this.occurrences.increment(globalOrd);
                }
            }
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }
    }
}

