/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.base;

import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.TableFormatConstants;
import org.apache.inlong.sort.formats.inlongmsg.FailureHandler;

public abstract class TextFormatBuilder<T extends TextFormatBuilder> {
    protected final RowFormatInfo rowFormatInfo;
    protected String charset = "UTF-8";
    protected Character escapeChar = TableFormatConstants.DEFAULT_ESCAPE_CHARACTER;
    protected Character quoteChar = TableFormatConstants.DEFAULT_QUOTE_CHARACTER;
    protected String nullLiteral = TableFormatConstants.DEFAULT_NULL_LITERAL;
    protected boolean ignoreErrors = false;
    protected FailureHandler failureHandler;

    protected TextFormatBuilder(RowFormatInfo rowFormatInfo) {
        this.rowFormatInfo = rowFormatInfo;
    }

    public T setCharset(String charset) {
        this.charset = charset;
        return (T)this;
    }

    public T setEscapeCharacter(char escapeChar) {
        this.escapeChar = Character.valueOf(escapeChar);
        return (T)this;
    }

    public T setQuoteCharacter(char quoteChar) {
        this.quoteChar = Character.valueOf(quoteChar);
        return (T)this;
    }

    public T setNullLiteral(String nullLiteral) {
        this.nullLiteral = nullLiteral;
        return (T)this;
    }

    public T setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
        return (T)this;
    }

    public T setFailureHandler(FailureHandler failureHandler) {
        this.failureHandler = failureHandler;
        return (T)this;
    }

    public T configure(DescriptorProperties descriptorProperties) {
        descriptorProperties.getOptionalString("format.charset").ifPresent(this::setCharset);
        descriptorProperties.getOptionalCharacter("format.escape-character").ifPresent(this::setEscapeCharacter);
        descriptorProperties.getOptionalCharacter("format.quote-character").ifPresent(this::setQuoteCharacter);
        descriptorProperties.getOptionalString("format.null-literal").ifPresent(this::setNullLiteral);
        descriptorProperties.getOptionalBoolean("format.ignore-errors").ifPresent(this::setIgnoreErrors);
        return (T)this;
    }
}

