/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.utils;

import com.zaxxer.hikari.HikariConfig;
import java.util.Objects;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.entities.JdbcConfig;

/*
 * Exception performing whole class analysis ignored.
 */
public class JdbcUtils {
    public static JdbcConfig buildMysqlConfig() {
        return JdbcUtils.doBuild((String)Configuration.getInstance().get("mysql.driver", "com.mysql.cj.jdbc.Driver"), (String)Configuration.getInstance().get("mysql.jdbc.url"), (String)Configuration.getInstance().get("mysql.username"), (String)Configuration.getInstance().get("mysql.password"));
    }

    private static JdbcConfig doBuild(String driverClass, String jdbcUrl, String userName, String password) {
        assert (Objects.nonNull(driverClass) && Objects.nonNull(jdbcUrl) && Objects.nonNull(userName) && Objects.nonNull(password));
        return new JdbcConfig(driverClass, jdbcUrl, userName, password);
    }

    public static HikariConfig buildHikariConfig(String driverClassName, String jdbcUrl, String userName, String passWord) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(driverClassName);
        hikariConfig.setJdbcUrl(jdbcUrl);
        hikariConfig.setUsername(userName);
        hikariConfig.setPassword(passWord);
        Configuration configuration = Configuration.getInstance();
        hikariConfig.setConnectionTimeout((long)configuration.get("datasource.connection.timeout.ms", 300000));
        hikariConfig.addDataSourceProperty("cachePrepStmts", (Object)configuration.get("cache.prep.stmts", true));
        hikariConfig.addDataSourceProperty("prepStmtCacheSize", (Object)configuration.get("prep.stmt.cache.size", 250));
        hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)configuration.get("prep.stmt.cache.sql.limit", 2048));
        hikariConfig.setMaximumPoolSize(configuration.get("datasource.pool.size", 2));
        return hikariConfig;
    }
}

