/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.flink;

import org.apache.flink.api.common.JobStatus;
import org.apache.inlong.manager.plugin.flink.FlinkService;
import org.apache.inlong.manager.plugin.flink.dto.FlinkConfig;
import org.apache.inlong.manager.plugin.flink.dto.FlinkInfo;
import org.apache.inlong.manager.plugin.flink.dto.StopWithSavepointRequest;
import org.apache.inlong.manager.plugin.flink.enums.TaskCommitType;
import org.apache.inlong.manager.plugin.util.FlinkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationTaskRunner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IntegrationTaskRunner.class);
    private static final Integer TRY_MAX_TIMES = 60;
    private static final Integer INTERVAL = 10;
    private final FlinkService flinkService;
    private final FlinkInfo flinkInfo;
    private final Integer commitType;

    public IntegrationTaskRunner(FlinkInfo flinkInfo, Integer commitType) {
        this.flinkInfo = flinkInfo;
        this.commitType = commitType;
        this.flinkService = FlinkService.getInstance();
    }

    @Override
    public void run() {
        TaskCommitType commitType = TaskCommitType.getInstance(this.commitType);
        if (commitType == null) {
            commitType = TaskCommitType.START_NOW;
        }
        switch (commitType) {
            case START_NOW: {
                try {
                    String jobId = this.flinkService.submit(this.flinkInfo);
                    this.flinkInfo.setJobId(jobId);
                    log.info("Start job {} success in backend", (Object)jobId);
                }
                catch (Exception e) {
                    String msg = String.format("Start job %s failed in backend exception[%s]", this.flinkInfo.getJobId(), FlinkUtils.getExceptionStackMsg(e));
                    log.warn(msg);
                    this.flinkInfo.setException(true);
                    this.flinkInfo.setExceptionMsg(msg);
                }
                break;
            }
            case RESUME: {
                try {
                    String jobId = this.flinkService.restore(this.flinkInfo);
                    log.info("Restore job {} success in backend", (Object)jobId);
                }
                catch (Exception e) {
                    String msg = String.format("Restore job %s failed in backend exception[%s]", this.flinkInfo.getJobId(), FlinkUtils.getExceptionStackMsg(e));
                    log.warn(msg);
                    this.flinkInfo.setException(true);
                    this.flinkInfo.setExceptionMsg(msg);
                }
                break;
            }
            case RESTART: {
                try {
                    StopWithSavepointRequest stopWithSavepointRequest = new StopWithSavepointRequest();
                    FlinkConfig flinkConfig = this.flinkService.getFlinkConfig();
                    stopWithSavepointRequest.setDrain(flinkConfig.isDrain());
                    stopWithSavepointRequest.setTargetDirectory(flinkConfig.getSavepointDirectory());
                    String location = this.flinkService.stopJob(this.flinkInfo, stopWithSavepointRequest);
                    this.flinkInfo.setSavepointPath(location);
                    log.info("the jobId: {} savepoint: {} ", (Object)this.flinkInfo.getJobId(), (Object)location);
                    for (int times = 0; times < TRY_MAX_TIMES; ++times) {
                        JobStatus jobStatus = this.flinkService.getJobStatus(this.flinkInfo);
                        if (jobStatus == JobStatus.FINISHED) {
                            try {
                                String jobId = this.flinkService.restore(this.flinkInfo);
                                log.info("Restore job {} success in backend", (Object)jobId);
                            }
                            catch (Exception e) {
                                log.error("Restore job failed in backend", (Throwable)e);
                            }
                            break;
                        }
                        log.info("Try start job  but the job {} is {}", (Object)this.flinkInfo.getJobId(), (Object)jobStatus.toString());
                        try {
                            Thread.sleep(INTERVAL * 1000);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    log.info("Restart job {} success in backend", (Object)this.flinkInfo.getJobId());
                }
                catch (Exception e) {
                    String msg = String.format("Restart job %s failed in backend exception[%s]", this.flinkInfo.getJobId(), FlinkUtils.getExceptionStackMsg(e));
                    log.warn(msg);
                    this.flinkInfo.setException(true);
                    this.flinkInfo.setExceptionMsg(msg);
                }
                break;
            }
            case STOP: {
                try {
                    StopWithSavepointRequest stopWithSavepointRequest = new StopWithSavepointRequest();
                    FlinkConfig flinkConfig = this.flinkService.getFlinkConfig();
                    stopWithSavepointRequest.setDrain(flinkConfig.isDrain());
                    stopWithSavepointRequest.setTargetDirectory(flinkConfig.getSavepointDirectory());
                    String location = this.flinkService.stopJob(this.flinkInfo, stopWithSavepointRequest);
                    this.flinkInfo.setSavepointPath(location);
                    log.info("the jobId {} savepoint: {} ", (Object)this.flinkInfo.getJobId(), (Object)location);
                }
                catch (Exception e) {
                    String msg = String.format("stop job %s failed in backend exception[%s]", this.flinkInfo.getJobId(), FlinkUtils.getExceptionStackMsg(e));
                    log.warn(msg);
                    this.flinkInfo.setException(true);
                    this.flinkInfo.setExceptionMsg(msg);
                }
                break;
            }
            case DELETE: {
                try {
                    this.flinkService.cancelJob(this.flinkInfo);
                    log.info("delete job {} success in backend", (Object)this.flinkInfo.getJobId());
                    JobStatus jobStatus = this.flinkService.getJobStatus(this.flinkInfo);
                    if (jobStatus.isTerminalState()) {
                        log.info("delete job {} success in backend", (Object)this.flinkInfo.getJobId());
                        break;
                    }
                    log.info("delete job {} failed in backend", (Object)this.flinkInfo.getJobId());
                }
                catch (Exception e) {
                    String msg = String.format("delete job %s failed in backend exception[%s]", this.flinkInfo.getJobId(), FlinkUtils.getExceptionStackMsg(e));
                    log.warn(msg);
                    this.flinkInfo.setException(true);
                    this.flinkInfo.setExceptionMsg(msg);
                }
                break;
            }
            default: {
                String msg = "not found commitType";
                this.flinkInfo.setException(true);
                log.warn(msg);
                this.flinkInfo.setExceptionMsg(msg);
            }
        }
    }
}

