/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.avro.shaded.org.apache.avro.util.Utf8;
import org.apache.flink.formats.avro.typeutils.AvroSerializer;

public class AvroTypeInfo<T extends SpecificRecordBase>
extends PojoTypeInfo<T> {
    private static final long serialVersionUID = 1L;

    public AvroTypeInfo(Class<T> typeClass) {
        super(typeClass, AvroTypeInfo.generateFieldsFromAvroSchema(typeClass));
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        return new AvroSerializer(this.getTypeClass());
    }

    @Internal
    private static <T extends SpecificRecordBase> List<PojoField> generateFieldsFromAvroSchema(Class<T> typeClass) {
        PojoTypeExtractor pte = new PojoTypeExtractor();
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        typeHierarchy.add(typeClass);
        TypeInformation ti = pte.analyzePojo(typeClass, typeHierarchy, null, null);
        if (!(ti instanceof PojoTypeInfo)) {
            throw new IllegalStateException("Expecting type to be a PojoTypeInfo");
        }
        PojoTypeInfo pti = (PojoTypeInfo)ti;
        ArrayList<PojoField> newFields = new ArrayList<PojoField>(pti.getTotalFields());
        for (int i = 0; i < pti.getArity(); ++i) {
            PojoField f = pti.getPojoFieldAt(i);
            TypeInformation newType = f.getTypeInformation();
            if (newType instanceof GenericTypeInfo && newType.getTypeClass().equals(CharSequence.class)) {
                newType = new GenericTypeInfo(Utf8.class);
            }
            PojoField newField = new PojoField(f.getField(), newType);
            newFields.add(newField);
        }
        return newFields;
    }

    private static class PojoTypeExtractor
    extends TypeExtractor {
        private PojoTypeExtractor() {
        }

        public <OUT, IN1, IN2> TypeInformation<OUT> analyzePojo(Type type, List<Type> typeHierarchy, TypeInformation<IN1> in1Type, TypeInformation<IN2> in2Type) {
            return super.analyzePojo(type, typeHierarchy, in1Type, in2Type);
        }
    }
}

