/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcFilters;
import org.apache.flink.orc.shim.OrcShim;
import org.apache.flink.orc.vector.OrcVectorizedBatchWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;

public abstract class OrcSplitReader<T, BATCH>
implements Closeable {
    private final OrcShim<BATCH> shim;
    private RecordReader orcRowsReader;
    protected final OrcVectorizedBatchWrapper<BATCH> rowBatchWrapper;
    private int rowsInBatch;
    protected int nextRow;

    public OrcSplitReader(OrcShim<BATCH> shim, Configuration conf, TypeDescription schema, int[] selectedFields, List<OrcFilters.Predicate> conjunctPredicates, int batchSize, Path path, long splitStart, long splitLength) throws IOException {
        this.shim = shim;
        this.orcRowsReader = shim.createRecordReader(conf, schema, selectedFields, conjunctPredicates, path, splitStart, splitLength);
        this.rowBatchWrapper = shim.createBatchWrapper(schema, batchSize);
        this.rowsInBatch = 0;
        this.nextRow = 0;
    }

    public void seekToRow(long rowCount) throws IOException {
        this.orcRowsReader.seekToRow(rowCount);
    }

    @VisibleForTesting
    public RecordReader getRecordReader() {
        return this.orcRowsReader;
    }

    public boolean reachedEnd() throws IOException {
        return !this.ensureBatch();
    }

    protected abstract int fillRows();

    public abstract T nextRecord(T var1) throws IOException;

    private boolean ensureBatch() throws IOException {
        if (this.nextRow >= this.rowsInBatch) {
            boolean moreRows = this.shim.nextBatch(this.orcRowsReader, this.rowBatchWrapper.getBatch());
            if (moreRows) {
                this.nextRow = 0;
                this.rowsInBatch = this.fillRows();
            }
            return moreRows;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.orcRowsReader != null) {
            this.orcRowsReader.close();
        }
        this.orcRowsReader = null;
    }
}

