/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.metric;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.metric.MetricListener;
import org.apache.inlong.common.metric.MetricListenerRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricObserver {
    public static final Logger LOG = LoggerFactory.getLogger(MetricObserver.class);
    private static final AtomicBoolean isInited = new AtomicBoolean(false);
    private static ScheduledExecutorService statExecutor = Executors.newScheduledThreadPool(5);

    public static void init(Map<String, String> commonProperties) {
        String[] domains;
        if (!isInited.compareAndSet(false, true)) {
            return;
        }
        String metricDomains = commonProperties.get("metricDomains");
        if (StringUtils.isBlank(metricDomains)) {
            return;
        }
        for (String domain : domains = metricDomains.split("\\s+")) {
            ImmutableMap<String, String> domainMap = MetricObserver.getSubProperties(commonProperties, "metricDomains." + domain + ".");
            List<MetricListener> listenerList = MetricObserver.parseDomain(domainMap);
            if (listenerList == null || listenerList.size() <= 0) continue;
            long snapshotInterval = Long.parseLong(domainMap.getOrDefault("snapshotInterval", "60000"));
            LOG.info("begin to register domain:{}, MetricListeners:{}, snapshotInterval:{}", domain, listenerList, snapshotInterval);
            statExecutor.scheduleWithFixedDelay(new MetricListenerRunnable(domain, listenerList), snapshotInterval, snapshotInterval, TimeUnit.MILLISECONDS);
        }
    }

    private static List<MetricListener> parseDomain(Map<String, String> domainMap) {
        String listeners = domainMap.get("domainListeners");
        if (StringUtils.isBlank(listeners)) {
            return null;
        }
        String[] listenerTypes = listeners.split("\\s+");
        ArrayList<MetricListener> listenerList = new ArrayList<MetricListener>();
        for (String listenerType : listenerTypes) {
            try {
                Class<?> listenerClass = ClassUtils.getClass(listenerType);
                Object listenerObject = listenerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (listenerObject == null || !(listenerObject instanceof MetricListener)) {
                    LOG.error("{} is not instance of MetricListener.", (Object)listenerType);
                    continue;
                }
                MetricListener listener = (MetricListener)listenerObject;
                listenerList.add(listener);
            }
            catch (Throwable t2) {
                LOG.error("Fail to init MetricListener:{},error:{}", (Object)listenerType, (Object)t2.getMessage());
            }
        }
        return listenerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmutableMap<String, String> getSubProperties(Map<String, String> commonProperties, String prefix) {
        Preconditions.checkArgument(prefix.endsWith("."), "The given prefix does not end with a period (" + prefix + ")");
        HashMap<String, String> result = Maps.newHashMap();
        Map<String, String> map = commonProperties;
        synchronized (map) {
            for (Map.Entry<String, String> entry : commonProperties.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(prefix)) continue;
                String name = key.substring(prefix.length());
                result.put(name, entry.getValue());
            }
            return ImmutableMap.copyOf(result);
        }
    }
}

