/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.json.canal;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.json.JsonRowSerializationSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.inlong.sort.formats.json.MysqlBinLogData;
import org.apache.inlong.sort.formats.json.canal.CanalJsonDecodingFormat;

public class CanalJsonSerializationSchema
implements SerializationSchema<Row> {
    private static final long serialVersionUID = 1L;
    private static final String OP_INSERT = "INSERT";
    private static final String OP_DELETE = "DELETE";
    private transient Row reuse;
    private final JsonRowSerializationSchema jsonSerializer;
    private final Map<Integer, CanalJsonDecodingFormat.ReadableMetadata> fieldIndexToMetadata;
    private final boolean isMigrateAll;
    private final ObjectMapper objectMapper;

    public CanalJsonSerializationSchema(RowType physicalRowType, Map<Integer, CanalJsonDecodingFormat.ReadableMetadata> fieldIndexToMetadata, boolean isMigrateAll) {
        this.isMigrateAll = isMigrateAll;
        this.objectMapper = isMigrateAll ? new ObjectMapper() : null;
        RowTypeInfo rowTypeInfo = CanalJsonSerializationSchema.createJsonRowType(TypeConversions.fromLogicalToDataType((LogicalType)physicalRowType), fieldIndexToMetadata.values(), isMigrateAll);
        this.jsonSerializer = JsonRowSerializationSchema.builder().withTypeInfo((TypeInformation<Row>)rowTypeInfo).build();
        this.fieldIndexToMetadata = fieldIndexToMetadata;
    }

    public void open(SerializationSchema.InitializationContext context) {
        this.reuse = new Row(2 + this.fieldIndexToMetadata.size());
    }

    public byte[] serialize(Row row) {
        try {
            MysqlBinLogData mysqlBinLogData = this.getMysqlBinLongData(row);
            Object[] arrayData = new Object[1];
            if (this.isMigrateAll) {
                String mapStr = (String)mysqlBinLogData.getPhysicalData().getFieldAs(0);
                arrayData[0] = this.convertStringToMap(mapStr);
            } else {
                arrayData[0] = mysqlBinLogData.getPhysicalData();
            }
            this.reuse.setField(0, (Object)arrayData);
            this.reuse.setField(1, (Object)CanalJsonSerializationSchema.rowKind2String(row.getKind()));
            Map<String, Object> metadataMap = mysqlBinLogData.getMetadataMap();
            int index = 2;
            for (CanalJsonDecodingFormat.ReadableMetadata readableMetadata : this.fieldIndexToMetadata.values()) {
                this.reuse.setField(index, metadataMap.get(readableMetadata.key));
                ++index;
            }
            return this.jsonSerializer.serialize(this.reuse);
        }
        catch (Throwable t2) {
            throw new RuntimeException("Could not serialize row '" + row + "'.", t2);
        }
    }

    public static String rowKind2String(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: 
            case UPDATE_AFTER: {
                return OP_INSERT;
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                return OP_DELETE;
            }
        }
        throw new UnsupportedOperationException("Unsupported operation '" + rowKind + "' for row kind.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanalJsonSerializationSchema that = (CanalJsonSerializationSchema)o;
        return Objects.equals(this.jsonSerializer, that.jsonSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.jsonSerializer);
    }

    private static RowTypeInfo createJsonRowType(DataType dataSchema, Collection<CanalJsonDecodingFormat.ReadableMetadata> metadataSet, boolean isMigrateAll) {
        DataType root = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"data", (DataType)DataTypes.ARRAY((DataType)(isMigrateAll ? DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()) : dataSchema))), DataTypes.FIELD((String)"type", (DataType)DataTypes.STRING())});
        List metadataFields = metadataSet.stream().map(m4 -> m4.requiredJsonField).distinct().collect(Collectors.toList());
        return (RowTypeInfo)TypeInfoDataTypeConverter.fromDataTypeToTypeInfo((DataType)DataTypeUtils.appendRowFields((DataType)root, metadataFields));
    }

    private MysqlBinLogData getMysqlBinLongData(Row consumedRow) {
        int consumedRowArity = consumedRow.getArity();
        Set<Integer> metadataIndices = this.fieldIndexToMetadata.keySet();
        Row physicalRow = new Row(consumedRowArity - metadataIndices.size());
        HashMap<String, Object> metadataMap = new HashMap<String, Object>();
        int physicalRowDataIndex = 0;
        for (int i = 0; i < consumedRowArity; ++i) {
            if (!metadataIndices.contains(i)) {
                physicalRow.setField(physicalRowDataIndex, consumedRow.getField(i));
                ++physicalRowDataIndex;
                continue;
            }
            metadataMap.put(this.fieldIndexToMetadata.get((Object)Integer.valueOf((int)i)).key, consumedRow.getField(i));
        }
        physicalRow.setKind(consumedRow.getKind());
        return new MysqlBinLogData(physicalRow, metadataMap);
    }

    private Map<?, ?> convertStringToMap(String input) throws JsonProcessingException {
        return this.objectMapper.readValue(input, Map.class);
    }
}

