/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="hbaseLoad")
public class HbaseLoadNode
extends LoadNode
implements InlongMetric,
Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="tableName")
    private String tableName;
    @JsonProperty(value="namespace")
    private String namespace;
    @JsonProperty(value="zookeeperQuorum")
    private String zookeeperQuorum;
    @JsonProperty(value="rowKey")
    private String rowKey;
    @JsonProperty(value="sinkBufferFlushMaxSize")
    private String sinkBufferFlushMaxSize;
    @JsonProperty(value="zookeeperZnodeParent")
    private String zookeeperZnodeParent;
    @JsonProperty(value="sinkBufferFlushMaxRows")
    private String sinkBufferFlushMaxRows;
    @JsonProperty(value="sinkBufferFlushInterval")
    private String sinkBufferFlushInterval;

    @JsonCreator
    public HbaseLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="namespace") String namespace, @JsonProperty(value="zookeeperQuorum") String zookeeperQuorum, @JsonProperty(value="rowKey") String rowKey, @JsonProperty(value="sinkBufferFlushMaxSize") String sinkBufferFlushMaxSize, @JsonProperty(value="zookeeperZnodeParent") String zookeeperZnodeParent, @JsonProperty(value="sinkBufferFlushMaxRows") String sinkBufferFlushMaxRows, @JsonProperty(value="sinkBufferFlushInterval") String sinkBufferFlushInterval) {
        super(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties);
        this.tableName = Preconditions.checkNotNull(tableName, "tableName of hbase is null");
        this.namespace = Preconditions.checkNotNull(namespace, "namespace of hbase is null");
        this.zookeeperQuorum = Preconditions.checkNotNull(zookeeperQuorum, "zookeeperQuorum of hbase is null");
        this.rowKey = Preconditions.checkNotNull(rowKey, "rowKey of hbase is null");
        this.sinkBufferFlushMaxSize = sinkBufferFlushMaxSize;
        this.zookeeperZnodeParent = zookeeperZnodeParent;
        this.sinkBufferFlushMaxRows = sinkBufferFlushMaxRows;
        this.sinkBufferFlushInterval = sinkBufferFlushInterval;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> map = super.tableOptions();
        map.put("connector", "hbase-2.2-inlong");
        map.put("table-name", this.namespace + ":" + this.tableName);
        map.put("zookeeper.quorum", this.zookeeperQuorum);
        if (StringUtils.isNotEmpty(this.sinkBufferFlushInterval)) {
            map.put("sink.buffer-flush.interval", this.sinkBufferFlushInterval);
        }
        if (StringUtils.isNotEmpty(this.zookeeperZnodeParent)) {
            map.put("zookeeper.znode.parent", this.zookeeperZnodeParent);
        }
        if (StringUtils.isNotEmpty(this.sinkBufferFlushMaxRows)) {
            map.put("sink.buffer-flush.max-rows", this.sinkBufferFlushMaxRows);
        }
        if (StringUtils.isNotEmpty(this.sinkBufferFlushMaxSize)) {
            map.put("sink.buffer-flush.max-size", this.sinkBufferFlushMaxSize);
        }
        return map;
    }

    @Override
    public String genTableName() {
        return this.tableName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HbaseLoadNode)) {
            return false;
        }
        HbaseLoadNode other = (HbaseLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$zookeeperQuorum = this.getZookeeperQuorum();
        String other$zookeeperQuorum = other.getZookeeperQuorum();
        if (this$zookeeperQuorum == null ? other$zookeeperQuorum != null : !this$zookeeperQuorum.equals(other$zookeeperQuorum)) {
            return false;
        }
        String this$rowKey = this.getRowKey();
        String other$rowKey = other.getRowKey();
        if (this$rowKey == null ? other$rowKey != null : !this$rowKey.equals(other$rowKey)) {
            return false;
        }
        String this$sinkBufferFlushMaxSize = this.getSinkBufferFlushMaxSize();
        String other$sinkBufferFlushMaxSize = other.getSinkBufferFlushMaxSize();
        if (this$sinkBufferFlushMaxSize == null ? other$sinkBufferFlushMaxSize != null : !this$sinkBufferFlushMaxSize.equals(other$sinkBufferFlushMaxSize)) {
            return false;
        }
        String this$zookeeperZnodeParent = this.getZookeeperZnodeParent();
        String other$zookeeperZnodeParent = other.getZookeeperZnodeParent();
        if (this$zookeeperZnodeParent == null ? other$zookeeperZnodeParent != null : !this$zookeeperZnodeParent.equals(other$zookeeperZnodeParent)) {
            return false;
        }
        String this$sinkBufferFlushMaxRows = this.getSinkBufferFlushMaxRows();
        String other$sinkBufferFlushMaxRows = other.getSinkBufferFlushMaxRows();
        if (this$sinkBufferFlushMaxRows == null ? other$sinkBufferFlushMaxRows != null : !this$sinkBufferFlushMaxRows.equals(other$sinkBufferFlushMaxRows)) {
            return false;
        }
        String this$sinkBufferFlushInterval = this.getSinkBufferFlushInterval();
        String other$sinkBufferFlushInterval = other.getSinkBufferFlushInterval();
        return !(this$sinkBufferFlushInterval == null ? other$sinkBufferFlushInterval != null : !this$sinkBufferFlushInterval.equals(other$sinkBufferFlushInterval));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HbaseLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $zookeeperQuorum = this.getZookeeperQuorum();
        result = result * 59 + ($zookeeperQuorum == null ? 43 : $zookeeperQuorum.hashCode());
        String $rowKey = this.getRowKey();
        result = result * 59 + ($rowKey == null ? 43 : $rowKey.hashCode());
        String $sinkBufferFlushMaxSize = this.getSinkBufferFlushMaxSize();
        result = result * 59 + ($sinkBufferFlushMaxSize == null ? 43 : $sinkBufferFlushMaxSize.hashCode());
        String $zookeeperZnodeParent = this.getZookeeperZnodeParent();
        result = result * 59 + ($zookeeperZnodeParent == null ? 43 : $zookeeperZnodeParent.hashCode());
        String $sinkBufferFlushMaxRows = this.getSinkBufferFlushMaxRows();
        result = result * 59 + ($sinkBufferFlushMaxRows == null ? 43 : $sinkBufferFlushMaxRows.hashCode());
        String $sinkBufferFlushInterval = this.getSinkBufferFlushInterval();
        result = result * 59 + ($sinkBufferFlushInterval == null ? 43 : $sinkBufferFlushInterval.hashCode());
        return result;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getZookeeperQuorum() {
        return this.zookeeperQuorum;
    }

    public String getRowKey() {
        return this.rowKey;
    }

    public String getSinkBufferFlushMaxSize() {
        return this.sinkBufferFlushMaxSize;
    }

    public String getZookeeperZnodeParent() {
        return this.zookeeperZnodeParent;
    }

    public String getSinkBufferFlushMaxRows() {
        return this.sinkBufferFlushMaxRows;
    }

    public String getSinkBufferFlushInterval() {
        return this.sinkBufferFlushInterval;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setZookeeperQuorum(String zookeeperQuorum) {
        this.zookeeperQuorum = zookeeperQuorum;
    }

    public void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }

    public void setSinkBufferFlushMaxSize(String sinkBufferFlushMaxSize) {
        this.sinkBufferFlushMaxSize = sinkBufferFlushMaxSize;
    }

    public void setZookeeperZnodeParent(String zookeeperZnodeParent) {
        this.zookeeperZnodeParent = zookeeperZnodeParent;
    }

    public void setSinkBufferFlushMaxRows(String sinkBufferFlushMaxRows) {
        this.sinkBufferFlushMaxRows = sinkBufferFlushMaxRows;
    }

    public void setSinkBufferFlushInterval(String sinkBufferFlushInterval) {
        this.sinkBufferFlushInterval = sinkBufferFlushInterval;
    }

    @Override
    public String toString() {
        return "HbaseLoadNode(tableName=" + this.getTableName() + ", namespace=" + this.getNamespace() + ", zookeeperQuorum=" + this.getZookeeperQuorum() + ", rowKey=" + this.getRowKey() + ", sinkBufferFlushMaxSize=" + this.getSinkBufferFlushMaxSize() + ", zookeeperZnodeParent=" + this.getZookeeperZnodeParent() + ", sinkBufferFlushMaxRows=" + this.getSinkBufferFlushMaxRows() + ", sinkBufferFlushInterval=" + this.getSinkBufferFlushInterval() + ")";
    }

    public HbaseLoadNode() {
    }
}

