/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.transform;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.Node;
import org.apache.inlong.sort.protocol.node.transform.DistinctNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TransformNode.class, name="baseTransform"), @JsonSubTypes.Type(value=DistinctNode.class, name="distinct")})
public class TransformNode
implements Node,
Serializable {
    private static final long serialVersionUID = -1202158328274891592L;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="fields")
    private List<FieldInfo> fields;
    @JsonProperty(value="fieldRelations")
    private List<FieldRelation> fieldRelations;
    @JsonProperty(value="filters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<FilterFunction> filters;
    @JsonProperty(value="filterStrategy")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private FilterStrategy filterStrategy;

    @JsonCreator
    public TransformNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy) {
        this.id = Preconditions.checkNotNull(id, "id is null");
        this.name = name;
        this.fields = Preconditions.checkNotNull(fields, "fields is null");
        Preconditions.checkState(!fields.isEmpty(), "fields is empty");
        this.fieldRelations = Preconditions.checkNotNull(fieldRelations, "fieldRelations is null");
        Preconditions.checkState(!fieldRelations.isEmpty(), "fieldRelations is empty");
        this.filters = filters;
        this.filterStrategy = filterStrategy;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getProperties() {
        return null;
    }

    @Override
    public String genTableName() {
        return "tansform_" + this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public List<FieldRelation> getFieldRelations() {
        return this.fieldRelations;
    }

    public List<FilterFunction> getFilters() {
        return this.filters;
    }

    public FilterStrategy getFilterStrategy() {
        return this.filterStrategy;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFields(List<FieldInfo> fields) {
        this.fields = fields;
    }

    public void setFieldRelations(List<FieldRelation> fieldRelations) {
        this.fieldRelations = fieldRelations;
    }

    public void setFilters(List<FilterFunction> filters) {
        this.filters = filters;
    }

    public void setFilterStrategy(FilterStrategy filterStrategy) {
        this.filterStrategy = filterStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformNode)) {
            return false;
        }
        TransformNode other = (TransformNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<FieldInfo> this$fields = this.getFields();
        List<FieldInfo> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        List<FieldRelation> this$fieldRelations = this.getFieldRelations();
        List<FieldRelation> other$fieldRelations = other.getFieldRelations();
        if (this$fieldRelations == null ? other$fieldRelations != null : !((Object)this$fieldRelations).equals(other$fieldRelations)) {
            return false;
        }
        List<FilterFunction> this$filters = this.getFilters();
        List<FilterFunction> other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        FilterStrategy this$filterStrategy = this.getFilterStrategy();
        FilterStrategy other$filterStrategy = other.getFilterStrategy();
        return !(this$filterStrategy == null ? other$filterStrategy != null : !((Object)((Object)this$filterStrategy)).equals((Object)other$filterStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransformNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<FieldInfo> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        List<FieldRelation> $fieldRelations = this.getFieldRelations();
        result = result * 59 + ($fieldRelations == null ? 43 : ((Object)$fieldRelations).hashCode());
        List<FilterFunction> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        FilterStrategy $filterStrategy = this.getFilterStrategy();
        result = result * 59 + ($filterStrategy == null ? 43 : ((Object)((Object)$filterStrategy)).hashCode());
        return result;
    }

    public String toString() {
        return "TransformNode(id=" + this.getId() + ", name=" + this.getName() + ", fields=" + this.getFields() + ", fieldRelations=" + this.getFieldRelations() + ", filters=" + this.getFilters() + ", filterStrategy=" + (Object)((Object)this.getFilterStrategy()) + ")";
    }

    public TransformNode() {
    }
}

