/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.GroupTimeWindowFunction;
import org.apache.inlong.sort.protocol.transformation.StringConstantParam;
import org.apache.inlong.sort.protocol.transformation.TimeUnitConstantParam;

@JsonTypeName(value="hop")
public class HopFunction
implements GroupTimeWindowFunction {
    @JsonProperty(value="timeAttr")
    private FieldInfo timeAttr;
    @JsonProperty(value="interval")
    private StringConstantParam interval;
    @JsonProperty(value="timeUnit")
    private TimeUnitConstantParam timeUnit;

    @JsonCreator
    public HopFunction(@JsonProperty(value="timeAttr") FieldInfo timeAttr, @JsonProperty(value="interval") StringConstantParam interval, @JsonProperty(value="timeUnit") TimeUnitConstantParam timeUnit) {
        this.timeAttr = Preconditions.checkNotNull(timeAttr, "timeAttr is null");
        this.interval = Preconditions.checkNotNull(interval, "interval is null");
        this.timeUnit = Preconditions.checkNotNull(timeUnit, "timeUnit is null");
    }

    @Override
    public String format() {
        return String.format("%s(%s, INTERVAL %s %s)", this.getName(), this.timeAttr.format(), this.interval.format(), this.timeUnit.format());
    }

    @Override
    public List<FunctionParam> getParams() {
        return Arrays.asList(this.timeAttr, this.interval, this.timeUnit);
    }

    @Override
    public String getName() {
        return "HOP";
    }

    public FieldInfo getTimeAttr() {
        return this.timeAttr;
    }

    @Override
    public StringConstantParam getInterval() {
        return this.interval;
    }

    @Override
    public TimeUnitConstantParam getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeAttr(FieldInfo timeAttr) {
        this.timeAttr = timeAttr;
    }

    public void setInterval(StringConstantParam interval) {
        this.interval = interval;
    }

    public void setTimeUnit(TimeUnitConstantParam timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HopFunction)) {
            return false;
        }
        HopFunction other = (HopFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FieldInfo this$timeAttr = this.getTimeAttr();
        FieldInfo other$timeAttr = other.getTimeAttr();
        if (this$timeAttr == null ? other$timeAttr != null : !((Object)this$timeAttr).equals(other$timeAttr)) {
            return false;
        }
        StringConstantParam this$interval = this.getInterval();
        StringConstantParam other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
            return false;
        }
        TimeUnitConstantParam this$timeUnit = this.getTimeUnit();
        TimeUnitConstantParam other$timeUnit = other.getTimeUnit();
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)this$timeUnit).equals(other$timeUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HopFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FieldInfo $timeAttr = this.getTimeAttr();
        result = result * 59 + ($timeAttr == null ? 43 : ((Object)$timeAttr).hashCode());
        StringConstantParam $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
        TimeUnitConstantParam $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)$timeUnit).hashCode());
        return result;
    }

    public String toString() {
        return "HopFunction(timeAttr=" + this.getTimeAttr() + ", interval=" + this.getInterval() + ", timeUnit=" + this.getTimeUnit() + ")";
    }

    public HopFunction() {
    }
}

