/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.relation;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;
import org.apache.inlong.sort.protocol.transformation.relation.FullOuterJoinRelation;
import org.apache.inlong.sort.protocol.transformation.relation.InnerJoinNodeRelation;
import org.apache.inlong.sort.protocol.transformation.relation.InnerTemporalJoinRelation;
import org.apache.inlong.sort.protocol.transformation.relation.IntervalJoinRelation;
import org.apache.inlong.sort.protocol.transformation.relation.LeftOuterJoinNodeRelation;
import org.apache.inlong.sort.protocol.transformation.relation.LeftOuterTemporalJoinRelation;
import org.apache.inlong.sort.protocol.transformation.relation.NodeRelation;
import org.apache.inlong.sort.protocol.transformation.relation.RightOuterJoinNodeRelation;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=FullOuterJoinRelation.class, name="fullOuterJoin"), @JsonSubTypes.Type(value=InnerJoinNodeRelation.class, name="innerJoin"), @JsonSubTypes.Type(value=LeftOuterJoinNodeRelation.class, name="leftOuterJoin"), @JsonSubTypes.Type(value=RightOuterJoinNodeRelation.class, name="rightOutJoin"), @JsonSubTypes.Type(value=InnerTemporalJoinRelation.class, name="innerTemporalJoin"), @JsonSubTypes.Type(value=LeftOuterTemporalJoinRelation.class, name="leftOuterTemporalJoin"), @JsonSubTypes.Type(value=IntervalJoinRelation.class, name="intervalJoin")})
public abstract class JoinRelation
extends NodeRelation {
    private static final long serialVersionUID = -213673939512251116L;
    @JsonProperty(value="joinConditionMap")
    private Map<String, List<FilterFunction>> joinConditionMap;

    public JoinRelation(@JsonProperty(value="inputs") List<String> inputs, @JsonProperty(value="outputs") List<String> outputs, @JsonProperty(value="joinConditionMap") Map<String, List<FilterFunction>> joinConditionMap) {
        super(inputs, outputs);
        this.joinConditionMap = Preconditions.checkNotNull(joinConditionMap, "joinConditionMap is null");
        Preconditions.checkState(!joinConditionMap.isEmpty(), "joinConditionMap is empty");
    }

    public abstract String format();

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinRelation)) {
            return false;
        }
        JoinRelation other = (JoinRelation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, List<FilterFunction>> this$joinConditionMap = this.getJoinConditionMap();
        Map<String, List<FilterFunction>> other$joinConditionMap = other.getJoinConditionMap();
        return !(this$joinConditionMap == null ? other$joinConditionMap != null : !((Object)this$joinConditionMap).equals(other$joinConditionMap));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JoinRelation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, List<FilterFunction>> $joinConditionMap = this.getJoinConditionMap();
        result = result * 59 + ($joinConditionMap == null ? 43 : ((Object)$joinConditionMap).hashCode());
        return result;
    }

    public Map<String, List<FilterFunction>> getJoinConditionMap() {
        return this.joinConditionMap;
    }

    public void setJoinConditionMap(Map<String, List<FilterFunction>> joinConditionMap) {
        this.joinConditionMap = joinConditionMap;
    }

    @Override
    public String toString() {
        return "JoinRelation(joinConditionMap=" + this.getJoinConditionMap() + ")";
    }

    public JoinRelation() {
    }
}

