/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class SqlNodeList
extends SqlNode
implements Iterable<SqlNode> {
    public static final SqlNodeList EMPTY = new SqlNodeList(SqlParserPos.ZERO){

        @Override
        public void add(SqlNode node) {
            throw new UnsupportedOperationException();
        }
    };
    public static final SqlNodeList SINGLETON_EMPTY = new SqlNodeList(ImmutableList.of(EMPTY), SqlParserPos.ZERO);
    public static final SqlNodeList SINGLETON_STAR = new SqlNodeList(ImmutableList.of(SqlIdentifier.STAR), SqlParserPos.ZERO);
    private final List<SqlNode> list;

    public SqlNodeList(SqlParserPos pos) {
        super(pos);
        this.list = new ArrayList<SqlNode>();
    }

    public SqlNodeList(Collection<? extends SqlNode> collection, SqlParserPos pos) {
        super(pos);
        this.list = new ArrayList<SqlNode>(collection);
    }

    @Override
    public Iterator<SqlNode> iterator() {
        return this.list.iterator();
    }

    public List<SqlNode> getList() {
        return this.list;
    }

    public void add(SqlNode node) {
        this.list.add(node);
    }

    @Override
    public SqlNodeList clone(SqlParserPos pos) {
        return new SqlNodeList(this.list, pos);
    }

    public SqlNode get(int n) {
        return this.list.get(n);
    }

    public SqlNode set(int n, SqlNode node) {
        return this.list.set(n, node);
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.FrameTypeEnum frameType = leftPrec > 0 || rightPrec > 0 ? SqlWriter.FrameTypeEnum.PARENTHESES : SqlWriter.FrameTypeEnum.SIMPLE;
        writer.list(frameType, SqlWriter.COMMA, this);
    }

    @Deprecated
    void commaList(SqlWriter writer) {
        this.unparse(writer, 0, 0);
    }

    @Deprecated
    void andOrList(SqlWriter writer, SqlBinaryOperator sepOp) {
        writer.list(SqlWriter.FrameTypeEnum.WHERE_LIST, sepOp, this);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        for (SqlNode child : this.list) {
            child.validate(validator, scope);
        }
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(SqlNode node, Litmus litmus) {
        if (!(node instanceof SqlNodeList)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlNodeList that = (SqlNodeList)node;
        if (this.size() != that.size()) {
            return litmus.fail("{} != {}", this, node);
        }
        for (int i = 0; i < this.list.size(); ++i) {
            SqlNode thatChild;
            SqlNode thisChild = this.list.get(i);
            if (thisChild.equalsDeep(thatChild = that.list.get(i), litmus)) continue;
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    public SqlNode[] toArray() {
        return this.list.toArray(new SqlNode[0]);
    }

    public static boolean isEmptyList(SqlNode node) {
        return node instanceof SqlNodeList && 0 == ((SqlNodeList)node).size();
    }

    public static SqlNodeList of(SqlNode node1) {
        SqlNodeList list = new SqlNodeList(SqlParserPos.ZERO);
        list.add(node1);
        return list;
    }

    public static SqlNodeList of(SqlNode node1, SqlNode node2) {
        SqlNodeList list = new SqlNodeList(SqlParserPos.ZERO);
        list.add(node1);
        list.add(node2);
        return list;
    }

    public static SqlNodeList of(SqlNode node1, SqlNode node2, SqlNode ... nodes) {
        SqlNodeList list = new SqlNodeList(SqlParserPos.ZERO);
        list.add(node1);
        list.add(node2);
        for (SqlNode node : nodes) {
            list.add(node);
        }
        return list;
    }

    @Override
    public void validateExpr(SqlValidator validator, SqlValidatorScope scope) {
        for (SqlNode node : this.list) {
            node.validateExpr(validator, scope);
        }
    }
}

