/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableList;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkRelFactories;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.plan.QueryOperationConverter;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalTableAggregate;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWatermarkAssigner;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowTableAggregate;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.runtime.groupwindow.NamedWindowProperty;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

@Internal
public final class FlinkRelBuilder
extends RelBuilder {
    private final QueryOperationConverter toRelNodeConverter;
    private final FlinkRelFactories.ExpandFactory expandFactory;
    private final FlinkRelFactories.RankFactory rankFactory;

    private FlinkRelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        super(context, cluster, relOptSchema);
        this.toRelNodeConverter = new QueryOperationConverter(this, context.unwrap(FlinkContext.class).isBatchMode());
        this.expandFactory = Util.first(context.unwrap(FlinkRelFactories.ExpandFactory.class), FlinkRelFactories.DEFAULT_EXPAND_FACTORY());
        this.rankFactory = Util.first(context.unwrap(FlinkRelFactories.RankFactory.class), FlinkRelFactories.DEFAULT_RANK_FACTORY());
    }

    public static FlinkRelBuilder of(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        return new FlinkRelBuilder((Context)Preconditions.checkNotNull((Object)context), cluster, relOptSchema);
    }

    public static FlinkRelBuilder of(RelOptCluster cluster, RelOptSchema relOptSchema) {
        return FlinkRelBuilder.of(cluster.getPlanner().getContext(), cluster, relOptSchema);
    }

    public static RelBuilderFactory proto(Context context) {
        return (cluster, schema) -> {
            Context clusterContext = cluster.getPlanner().getContext();
            Context chain = Contexts.chain(context, clusterContext);
            return FlinkRelBuilder.of(chain, cluster, schema);
        };
    }

    public static RelBuilder pushFunctionScan(RelBuilder relBuilder, SqlOperator operator, int inputCount, Iterable<RexNode> operands, List<String> aliases) {
        Preconditions.checkArgument((boolean)(operator instanceof BridgingSqlFunction.WithTableFunction), (Object)"Table function expected.");
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        RelDataTypeFactory typeFactory = relBuilder.getTypeFactory();
        LinkedList<RelNode> inputs = new LinkedList<RelNode>();
        for (int i = 0; i < inputCount; ++i) {
            inputs.add(0, relBuilder.build());
        }
        List operandList = CollectionUtil.iterableToList(operands);
        RelDataType functionRelDataType = rexBuilder.deriveReturnType(operator, operandList);
        List<RelDataType> fieldRelDataTypes = functionRelDataType.isStruct() ? functionRelDataType.getFieldList().stream().map(RelDataTypeField::getType).collect(Collectors.toList()) : Collections.singletonList(functionRelDataType);
        RelDataType rowRelDataType = typeFactory.createStructType(fieldRelDataTypes, aliases);
        RexNode call = rexBuilder.makeCall(rowRelDataType, operator, operandList);
        LogicalTableFunctionScan functionScan = LogicalTableFunctionScan.create(relBuilder.getCluster(), inputs, call, null, rowRelDataType, Collections.emptySet());
        return relBuilder.push(functionScan);
    }

    public RelBuilder expand(List<List<RexNode>> projects, int expandIdIndex) {
        RelNode input = this.build();
        RelNode expand = this.expandFactory.createExpand(input, projects, expandIdIndex);
        return this.push(expand);
    }

    public RelBuilder rank(ImmutableBitSet partitionKey, RelCollation orderKey, RankType rankType, RankRange rankRange, RelDataTypeField rankNumberType, boolean outputRankNumber) {
        RelNode input = this.build();
        RelNode rank = this.rankFactory.createRank(input, partitionKey, orderKey, rankType, rankRange, rankNumberType, outputRankNumber);
        return this.push(rank);
    }

    @Override
    public RelBuilder aggregate(RelBuilder.GroupKey groupKey, Iterable<RelBuilder.AggCall> aggCalls) {
        RelNode relNode = super.aggregate(groupKey, aggCalls).build();
        if (relNode instanceof LogicalAggregate) {
            LogicalAggregate logicalAggregate = (LogicalAggregate)relNode;
            if (AggregateUtil.isTableAggregate(logicalAggregate.getAggCallList())) {
                relNode = LogicalTableAggregate.create(logicalAggregate);
            } else if (FlinkRelBuilder.isCountStarAgg(logicalAggregate)) {
                RelNode newAggInput = this.push(logicalAggregate.getInput(0)).project(this.literal(0)).build();
                relNode = logicalAggregate.copy(logicalAggregate.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)newAggInput));
            }
        }
        return this.push(relNode);
    }

    public RelBuilder windowAggregate(LogicalWindow window, RelBuilder.GroupKey groupKey, List<NamedWindowProperty> namedProperties, Iterable<RelBuilder.AggCall> aggCalls) {
        LogicalAggregate aggregate = (LogicalAggregate)super.transform(t -> t.withPruneInputOfAggregate(false)).push(this.build()).aggregate(groupKey, aggCalls).build();
        SingleRel windowAggregate = AggregateUtil.isTableAggregate(aggregate.getAggCallList()) ? LogicalWindowTableAggregate.create(window, namedProperties, aggregate) : LogicalWindowAggregate.create(window, namedProperties, aggregate);
        return this.push(windowAggregate);
    }

    public RelBuilder watermark(int rowtimeFieldIndex, RexNode watermarkExpr) {
        RelNode input = this.build();
        LogicalWatermarkAssigner relNode = LogicalWatermarkAssigner.create(this.cluster, input, rowtimeFieldIndex, watermarkExpr);
        return this.push(relNode);
    }

    public RelBuilder queryOperation(QueryOperation queryOperation) {
        RelNode relNode = (RelNode)queryOperation.accept((QueryOperationVisitor)this.toRelNodeConverter);
        return this.push(relNode);
    }

    public RelBuilder scan(ObjectIdentifier identifier, Map<String, String> dynamicOptions) {
        ArrayList<RelHint> hints = new ArrayList<RelHint>();
        hints.add(RelHint.builder("OPTIONS").hintOptions(dynamicOptions).build());
        RelOptTable.ToRelContext toRelContext = ViewExpanders.simpleContext(this.cluster, hints);
        RelNode relNode = this.relOptSchema.getTableForMember(identifier.toList()).toRel(toRelContext);
        return this.push(relNode);
    }

    @Override
    public FlinkTypeFactory getTypeFactory() {
        return (FlinkTypeFactory)super.getTypeFactory();
    }

    @Override
    public RelBuilder transform(UnaryOperator<RelBuilder.Config> transform) {
        Context mergedContext = Contexts.of(transform.apply(RelBuilder.Config.DEFAULT), this.cluster.getPlanner().getContext());
        return FlinkRelBuilder.of(mergedContext, this.cluster, this.relOptSchema);
    }

    private static boolean isCountStarAgg(LogicalAggregate agg) {
        if (agg.getGroupCount() != 0 || agg.getAggCallList().size() != 1) {
            return false;
        }
        AggregateCall call = agg.getAggCallList().get(0);
        return call.getAggregation().getKind() == SqlKind.COUNT && call.filterArg == -1 && call.getArgList().isEmpty();
    }
}

