/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.util.Collections;
import org.apache.flink.table.data.utils.CastExecutor;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratedExpressionCastExecutor;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.ExpressionCodeGeneratorCastRule;
import org.apache.flink.table.runtime.generated.CompileUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;

abstract class AbstractExpressionCodeGeneratorCastRule<IN, OUT>
extends AbstractNullAwareCodeGeneratorCastRule<IN, OUT>
implements ExpressionCodeGeneratorCastRule<IN, OUT> {
    protected AbstractExpressionCodeGeneratorCastRule(CastRulePredicate predicate) {
        super(predicate);
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return returnVariable + " = " + this.generateExpression(context, inputTerm, inputLogicalType, targetLogicalType) + ";\n";
    }

    @Override
    public CastExecutor<IN, OUT> create(CastRule.Context context, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        if (this.canFail(inputLogicalType, targetLogicalType)) {
            return super.create(context, inputLogicalType, targetLogicalType);
        }
        String inputArgumentName = "inputValue";
        String expression = CastRuleUtils.ternaryOperator("inputValue == null", "null", CastRuleUtils.box(this.generateExpression(AbstractExpressionCodeGeneratorCastRule.createCodeGeneratorCastRuleContext(context), CastRuleUtils.unbox(CastRuleUtils.cast(CodeGenUtils.boxedTypeTermForType(inputLogicalType), "inputValue"), inputLogicalType), inputLogicalType, targetLogicalType), targetLogicalType));
        return new CodeGeneratedExpressionCastExecutor(CompileUtils.compileExpression((String)expression, Collections.singletonList("inputValue"), Collections.singletonList(LogicalTypeUtils.toInternalConversionClass((LogicalType)inputLogicalType)), (Class)LogicalTypeUtils.toInternalConversionClass((LogicalType)targetLogicalType)));
    }

    private static CodeGeneratorCastRule.Context createCodeGeneratorCastRuleContext(final CastRule.Context ctx) {
        return new CodeGeneratorCastRule.Context(){

            @Override
            public boolean isPrinting() {
                return ctx.isPrinting();
            }

            @Override
            public boolean legacyBehaviour() {
                return ctx.legacyBehaviour();
            }

            @Override
            public String getSessionTimeZoneTerm() {
                return "java.util.TimeZone.getTimeZone(\"" + ctx.getSessionZoneId().getId() + "\")";
            }

            @Override
            public String declareVariable(String type, String variablePrefix) {
                throw new UnsupportedOperationException("No variable can be declared when using AbstractExpressionCodeGeneratorCastRule. You should use AbstractCodeGeneratorCastRule instead.");
            }

            @Override
            public String declareTypeSerializer(LogicalType type) {
                throw new UnsupportedOperationException("No type serializer can be declared when using AbstractExpressionCodeGeneratorCastRule. You should use AbstractCodeGeneratorCastRule instead.");
            }

            @Override
            public String declareClassField(String type, String field, String initialization) {
                throw new UnsupportedOperationException("No class field can be declared when using AbstractExpressionCodeGeneratorCastRule. You should use AbstractCodeGeneratorCastRule instead.");
            }
        };
    }
}

