/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public class CastRulePredicate {
    private final Set<LogicalType> targetTypes;
    private final Set<LogicalTypeRoot> inputTypeRoots;
    private final Set<LogicalTypeRoot> targetTypeRoots;
    private final Set<LogicalTypeFamily> inputTypeFamilies;
    private final Set<LogicalTypeFamily> targetTypeFamilies;
    private final BiPredicate<LogicalType, LogicalType> customPredicate;

    private CastRulePredicate(Set<LogicalType> targetTypes, Set<LogicalTypeRoot> inputTypeRoots, Set<LogicalTypeRoot> targetTypeRoots, Set<LogicalTypeFamily> inputTypeFamilies, Set<LogicalTypeFamily> targetTypeFamilies, BiPredicate<LogicalType, LogicalType> customPredicate) {
        this.targetTypes = targetTypes;
        this.inputTypeRoots = inputTypeRoots;
        this.targetTypeRoots = targetTypeRoots;
        this.inputTypeFamilies = inputTypeFamilies;
        this.targetTypeFamilies = targetTypeFamilies;
        this.customPredicate = customPredicate;
    }

    public Set<LogicalType> getTargetTypes() {
        return this.targetTypes;
    }

    public Set<LogicalTypeRoot> getInputTypeRoots() {
        return this.inputTypeRoots;
    }

    public Set<LogicalTypeRoot> getTargetTypeRoots() {
        return this.targetTypeRoots;
    }

    public Set<LogicalTypeFamily> getInputTypeFamilies() {
        return this.inputTypeFamilies;
    }

    public Set<LogicalTypeFamily> getTargetTypeFamilies() {
        return this.targetTypeFamilies;
    }

    public Optional<BiPredicate<LogicalType, LogicalType>> getCustomPredicate() {
        return Optional.ofNullable(this.customPredicate);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<LogicalTypeRoot> inputTypeRoots = new HashSet<LogicalTypeRoot>();
        private final Set<LogicalTypeRoot> targetTypeRoots = new HashSet<LogicalTypeRoot>();
        private final Set<LogicalType> targetTypes = new HashSet<LogicalType>();
        private final Set<LogicalTypeFamily> inputTypeFamilies = new HashSet<LogicalTypeFamily>();
        private final Set<LogicalTypeFamily> targetTypeFamilies = new HashSet<LogicalTypeFamily>();
        private BiPredicate<LogicalType, LogicalType> customPredicate;

        public Builder input(LogicalTypeRoot inputTypeRoot) {
            this.inputTypeRoots.add(inputTypeRoot);
            return this;
        }

        public Builder target(LogicalTypeRoot outputTypeRoot) {
            this.targetTypeRoots.add(outputTypeRoot);
            return this;
        }

        public Builder target(LogicalType outputType) {
            this.targetTypes.add(outputType);
            return this;
        }

        public Builder input(LogicalTypeFamily inputTypeFamily) {
            this.inputTypeFamilies.add(inputTypeFamily);
            return this;
        }

        public Builder target(LogicalTypeFamily outputTypeFamily) {
            this.targetTypeFamilies.add(outputTypeFamily);
            return this;
        }

        public Builder predicate(BiPredicate<LogicalType, LogicalType> customPredicate) {
            this.customPredicate = customPredicate;
            return this;
        }

        public CastRulePredicate build() {
            return new CastRulePredicate(Collections.unmodifiableSet(this.targetTypes), Collections.unmodifiableSet(this.inputTypeRoots), Collections.unmodifiableSet(this.targetTypeRoots), Collections.unmodifiableSet(this.inputTypeFamilies), Collections.unmodifiableSet(this.targetTypeFamilies), this.customPredicate);
        }
    }
}

