/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.logical;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@JsonTypeName(value="WindowAttached")
public class WindowAttachedWindowingStrategy
extends WindowingStrategy {
    public static final String FIELD_NAME_WINDOW_START = "windowStart";
    public static final String FIELD_NAME_WINDOW_END = "windowEnd";
    @JsonProperty(value="windowStart")
    private final int windowStart;
    @JsonProperty(value="windowEnd")
    private final int windowEnd;

    @JsonCreator
    public WindowAttachedWindowingStrategy(@JsonProperty(value="window") WindowSpec window, @JsonProperty(value="timeAttributeType") LogicalType timeAttributeType, @JsonProperty(value="windowStart") int windowStart, @JsonProperty(value="windowEnd") int windowEnd) {
        super(window, timeAttributeType);
        Preconditions.checkArgument((windowEnd >= 0 ? 1 : 0) != 0);
        this.windowStart = windowStart;
        this.windowEnd = windowEnd;
    }

    public WindowAttachedWindowingStrategy(WindowSpec window, LogicalType timeAttributeType, int windowEnd) {
        super(window, timeAttributeType);
        Preconditions.checkArgument((windowEnd >= 0 ? 1 : 0) != 0);
        this.windowStart = -1;
        this.windowEnd = windowEnd;
    }

    @Override
    public String toSummaryString(String[] inputFieldNames) {
        String windowing;
        Preconditions.checkArgument((this.windowEnd < inputFieldNames.length ? 1 : 0) != 0);
        if (this.windowStart < 0) {
            windowing = String.format("win_end=[%s]", inputFieldNames[this.windowEnd]);
        } else {
            Preconditions.checkArgument((this.windowStart < inputFieldNames.length ? 1 : 0) != 0);
            windowing = String.format("win_start=[%s], win_end=[%s]", inputFieldNames[this.windowStart], inputFieldNames[this.windowEnd]);
        }
        return this.window.toSummaryString(windowing);
    }

    public int getWindowStart() {
        return this.windowStart;
    }

    public int getWindowEnd() {
        return this.windowEnd;
    }
}

