/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.time.Duration;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;

@Internal
public final class ExecNodeConfig
implements ReadableConfig {
    private final TableConfig tableConfig;
    private final ReadableConfig nodeConfig;
    private final boolean isCompiled;

    private ExecNodeConfig(TableConfig tableConfig, ReadableConfig nodeConfig, boolean isCompiled) {
        this.nodeConfig = nodeConfig;
        this.tableConfig = tableConfig;
        this.isCompiled = isCompiled;
    }

    static ExecNodeConfig of(TableConfig tableConfig, ReadableConfig nodeConfig, boolean isCompiled) {
        return new ExecNodeConfig(tableConfig, nodeConfig, isCompiled);
    }

    @Deprecated
    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public <T> T get(ConfigOption<T> option) {
        return (T)this.nodeConfig.getOptional(option).orElseGet(() -> this.tableConfig.get(option));
    }

    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        Optional tableValue = this.nodeConfig.getOptional(option);
        if (tableValue.isPresent()) {
            return tableValue;
        }
        return this.tableConfig.getOptional(option);
    }

    public long getStateRetentionTime() {
        return ((Duration)this.get(ExecutionConfigOptions.IDLE_STATE_RETENTION)).toMillis();
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public boolean shouldSetUid() {
        ExecutionConfigOptions.UidGeneration uidGeneration = (ExecutionConfigOptions.UidGeneration)this.get(ExecutionConfigOptions.TABLE_EXEC_UID_GENERATION);
        switch (uidGeneration) {
            case PLAN_ONLY: {
                return this.isCompiled && (Boolean)this.get(ExecutionConfigOptions.TABLE_EXEC_LEGACY_TRANSFORMATION_UIDS) == false;
            }
            case ALWAYS: {
                return true;
            }
            case DISABLED: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown UID generation strategy: " + uidGeneration);
    }
}

