/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.FlinkVersion;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.guava30.com.google.common.collect.Sets;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonPlanEdge;
import org.apache.flink.table.planner.plan.nodes.exec.visitor.ExecNodeVisitorImpl;
import org.apache.flink.util.Preconditions;

@Internal
final class JsonPlanGraph {
    static final String FIELD_NAME_FLINK_VERSION = "flinkVersion";
    static final String FIELD_NAME_NODES = "nodes";
    static final String FIELD_NAME_EDGES = "edges";
    @JsonProperty(value="flinkVersion")
    private final FlinkVersion flinkVersion;
    @JsonProperty(value="nodes")
    private final List<ExecNode<?>> nodes;
    @JsonProperty(value="edges")
    private final List<JsonPlanEdge> edges;

    @JsonCreator
    JsonPlanGraph(@JsonProperty(value="flinkVersion") FlinkVersion flinkVersion, @JsonProperty(value="nodes") List<ExecNode<?>> nodes, @JsonProperty(value="edges") List<JsonPlanEdge> edges) {
        this.flinkVersion = flinkVersion;
        this.nodes = nodes;
        this.edges = edges;
    }

    static JsonPlanGraph fromExecNodeGraph(ExecNodeGraph execGraph) {
        final ArrayList allNodes = new ArrayList();
        final ArrayList<JsonPlanEdge> allEdges = new ArrayList<JsonPlanEdge>();
        final HashSet nodesIds = new HashSet();
        final Set visitedNodes = Sets.newIdentityHashSet();
        ExecNodeVisitorImpl visitor = new ExecNodeVisitorImpl(){

            @Override
            public void visit(ExecNode<?> node) {
                if (visitedNodes.contains(node)) {
                    return;
                }
                super.visitInputs(node);
                int id = node.getId();
                if (nodesIds.contains(id)) {
                    throw new TableException(String.format("The id: %s is not unique for ExecNode: %s.\nplease check it.", id, node.getDescription()));
                }
                allNodes.add(node);
                nodesIds.add(id);
                visitedNodes.add(node);
                for (ExecEdge execEdge : node.getInputEdges()) {
                    allEdges.add(JsonPlanEdge.fromExecEdge(execEdge));
                }
            }
        };
        execGraph.getRootNodes().forEach(visitor::visit);
        Preconditions.checkArgument((allNodes.size() == nodesIds.size() ? 1 : 0) != 0);
        return new JsonPlanGraph(execGraph.getFlinkVersion(), allNodes, allEdges);
    }

    ExecNodeGraph convertToExecNodeGraph() {
        HashMap idToExecNodes = new HashMap();
        for (ExecNode<?> execNode : this.nodes) {
            int id = execNode.getId();
            if (idToExecNodes.containsKey(id)) {
                throw new TableException(String.format("The id: %s is not unique for ExecNode: %s.\nplease check it.", id, execNode.getDescription()));
            }
            idToExecNodes.put(id, execNode);
        }
        HashMap<Integer, List> idToInputEdges = new HashMap<Integer, List>();
        HashMap<Integer, List> idToOutputEdges = new HashMap<Integer, List>();
        for (JsonPlanEdge edge : this.edges) {
            ExecNode source = (ExecNode)idToExecNodes.get(edge.getSourceId());
            if (source == null) {
                throw new TableException(String.format("Source node id: %s is not found in nodes.", edge.getSourceId()));
            }
            ExecNode target = (ExecNode)idToExecNodes.get(edge.getTargetId());
            if (target == null) {
                throw new TableException(String.format("Target node id: %s is not found in nodes.", edge.getTargetId()));
            }
            ExecEdge execEdge = ExecEdge.builder().source(source).target(target).shuffle(edge.getShuffle()).exchangeMode(edge.getExchangeMode()).build();
            idToInputEdges.computeIfAbsent(target.getId(), n -> new ArrayList()).add(execEdge);
            idToOutputEdges.computeIfAbsent(source.getId(), n -> new ArrayList()).add(execEdge);
        }
        ArrayList rootNodes = new ArrayList();
        for (Map.Entry entry : idToExecNodes.entrySet()) {
            int id = (Integer)entry.getKey();
            ExecNode node = (ExecNode)entry.getValue();
            List inputEdges = idToInputEdges.getOrDefault(id, new ArrayList());
            node.setInputEdges(inputEdges);
            if (idToOutputEdges.containsKey(id)) continue;
            rootNodes.add(node);
        }
        return new ExecNodeGraph(this.flinkVersion, rootNodes);
    }
}

