/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.time.LocalDateTime;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.annotation.Internal;

@Internal
public class TimestampStringUtils {
    public static TimestampString fromLocalDateTime(LocalDateTime ldt) {
        return new TimestampString(ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond()).withNanos(ldt.getNano());
    }

    public static LocalDateTime toLocalDateTime(TimestampString timestampString) {
        String v = timestampString.toString();
        int year = Integer.parseInt(v.substring(0, 4));
        int month = Integer.parseInt(v.substring(5, 7));
        int day = Integer.parseInt(v.substring(8, 10));
        int h = Integer.parseInt(v.substring(11, 13));
        int m = Integer.parseInt(v.substring(14, 16));
        int s = Integer.parseInt(v.substring(17, 19));
        int nano = TimestampStringUtils.getNanosInSecond(v);
        return LocalDateTime.of(year, month, day, h, m, s, nano);
    }

    private static int getNanosInSecond(String v) {
        if (v.length() == 19) {
            return 0;
        }
        return Integer.parseInt(v.substring(20)) * (int)Math.pow(10.0, 9 - (v.length() - 20));
    }
}

