/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.file;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.OffsetProfile;
import org.apache.inlong.agent.core.task.MemoryManager;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.message.DefaultMessage;
import org.apache.inlong.agent.metrics.AgentMetricItem;
import org.apache.inlong.agent.metrics.AgentMetricItemSet;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.file.Source;
import org.apache.inlong.agent.plugin.sources.extend.ExtendedHandler;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSource
implements Source {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSource.class);
    protected final Integer BATCH_READ_LINE_COUNT = 10000;
    protected final Integer BATCH_READ_LINE_TOTAL_LEN = 0x100000;
    protected final Integer CACHE_QUEUE_SIZE = 10 * this.BATCH_READ_LINE_COUNT;
    protected final Integer WAIT_TIMEOUT_MS = 10;
    private final Integer SOURCE_NO_UPDATE_INTERVAL_MS = 300000;
    private final Integer CORE_THREAD_PRINT_INTERVAL_MS = 1000;
    protected BlockingQueue<SourceData> queue;
    protected String inlongGroupId;
    protected String inlongStreamId;
    protected AgentMetricItemSet metricItemSet;
    protected AgentMetricItem sourceMetric;
    protected String metricName;
    protected Map<String, String> dimensions;
    protected static final AtomicLong METRIX_INDEX = new AtomicLong(0L);
    protected volatile boolean runnable = true;
    protected volatile boolean running = false;
    protected String taskId;
    protected long auditVersion;
    protected String instanceId;
    protected InstanceProfile profile;
    protected String extendClass;
    private ExtendedHandler extendedHandler;
    protected boolean isRealTime = false;
    protected volatile long emptyCount = 0L;
    protected int maxPackSize;
    private static final ThreadPoolExecutor EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("source-pool"));
    protected OffsetProfile offsetProfile;
    protected boolean sourceError = false;

    public void init(InstanceProfile profile) {
        this.profile = profile;
        this.taskId = profile.getTaskId();
        this.auditVersion = Long.parseLong(profile.get("task.auditVersion"));
        this.instanceId = profile.getInstanceId();
        this.inlongGroupId = profile.getInlongGroupId();
        this.inlongStreamId = profile.getInlongStreamId();
        this.maxPackSize = profile.getInt("proxy.package.maxSize", 512000);
        this.queue = new LinkedBlockingQueue<SourceData>(this.CACHE_QUEUE_SIZE);
        String cycleUnit = profile.get("task.cycleUnit");
        if (cycleUnit.compareToIgnoreCase("R") == 0) {
            this.isRealTime = true;
        }
        this.initOffset();
        this.registerMetric();
        this.initExtendHandler();
        this.initSource(profile);
    }

    protected abstract void initExtendClass();

    protected abstract void initSource(InstanceProfile var1);

    protected void initOffset() {
        this.offsetProfile = OffsetManager.getInstance().getOffset(this.taskId, this.instanceId);
    }

    public void start() {
        EXECUTOR_SERVICE.execute(this.run());
    }

    private Runnable run() {
        return () -> {
            AgentThreadFactory.nameThread((String)this.getThreadName());
            this.running = true;
            try {
                this.doRun();
            }
            catch (Throwable e) {
                LOGGER.error("do run error maybe file deleted: ", e);
                ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)e);
            }
            this.running = false;
        };
    }

    private void doRun() {
        long lastPrintTime = 0L;
        while (this.isRunnable() && this.prepareToRead()) {
            boolean suc4Queue;
            List<SourceData> lines = this.readFromSource();
            if (lines == null || lines.isEmpty()) {
                this.emptyCount = this.queue.isEmpty() ? ++this.emptyCount : 0L;
                MemoryManager.getInstance().release("agent.global.reader.source.permit", this.BATCH_READ_LINE_TOTAL_LEN.intValue());
                AgentUtils.silenceSleepInMs((long)this.WAIT_TIMEOUT_MS.intValue());
                continue;
            }
            this.emptyCount = 0L;
            for (int i = 0; i < lines.size() && (suc4Queue = this.waitForPermit("agent.global.reader.queue.permit", lines.get(i).getData().length)); ++i) {
                this.putIntoQueue(lines.get(i));
            }
            MemoryManager.getInstance().release("agent.global.reader.source.permit", this.BATCH_READ_LINE_TOTAL_LEN.intValue());
            if (AgentUtils.getCurrentTime() - lastPrintTime <= (long)this.CORE_THREAD_PRINT_INTERVAL_MS.intValue()) continue;
            lastPrintTime = AgentUtils.getCurrentTime();
            this.printCurrentState();
        }
    }

    protected abstract void printCurrentState();

    private boolean prepareToRead() {
        try {
            if (!this.doPrepareToRead()) {
                return false;
            }
            return this.waitForPermit("agent.global.reader.source.permit", this.BATCH_READ_LINE_TOTAL_LEN);
        }
        catch (Throwable e) {
            LOGGER.error("prepare to read {} error:", (Object)this.instanceId, (Object)e);
            this.sourceError = true;
            return false;
        }
    }

    protected abstract boolean doPrepareToRead();

    protected abstract List<SourceData> readFromSource();

    private boolean waitForPermit(String permitName, int permitLen) {
        boolean suc = false;
        while (!suc) {
            suc = MemoryManager.getInstance().tryAcquire(permitName, permitLen);
            if (suc) continue;
            MemoryManager.getInstance().printDetail(permitName, "source");
            if (!this.isRunnable()) {
                return false;
            }
            AgentUtils.silenceSleepInMs((long)this.WAIT_TIMEOUT_MS.intValue());
        }
        return true;
    }

    private void putIntoQueue(SourceData sourceData) {
        if (sourceData == null) {
            return;
        }
        try {
            boolean offerSuc = false;
            while (this.isRunnable() && !offerSuc) {
                offerSuc = this.queue.offer(sourceData, this.WAIT_TIMEOUT_MS.intValue(), TimeUnit.MILLISECONDS);
            }
            if (!offerSuc) {
                MemoryManager.getInstance().release("agent.global.reader.queue.permit", sourceData.getData().length);
            }
            LOGGER.debug("Put in source queue {} {}", (Object)new String(sourceData.getData()), (Object)this.inlongGroupId);
        }
        catch (InterruptedException e) {
            MemoryManager.getInstance().release("agent.global.reader.queue.permit", sourceData.getData().length);
            LOGGER.error("fetchData offer failed", (Throwable)e);
        }
    }

    protected abstract String getThreadName();

    private void registerMetric() {
        this.dimensions = new HashMap<String, String>();
        this.dimensions.put("pluginId", this.getClass().getSimpleName());
        this.dimensions.put("inlongGroupId", this.inlongGroupId);
        this.dimensions.put("inlongStreamId", this.inlongStreamId);
        this.metricName = String.join((CharSequence)"-", this.getClass().getSimpleName(), String.valueOf(METRIX_INDEX.incrementAndGet()));
        this.metricItemSet = new AgentMetricItemSet(this.metricName);
        MetricRegister.register((MetricItemSet)this.metricItemSet);
        this.sourceMetric = (AgentMetricItem)this.metricItemSet.findMetricItem(this.dimensions);
    }

    private void initExtendHandler() {
        this.initExtendClass();
        Constructor<?> constructor = null;
        try {
            constructor = Class.forName(this.extendClass).getDeclaredConstructor(InstanceProfile.class);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("init {} NoSuchMethodException error", (Object)this.instanceId, (Object)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("init {} ClassNotFoundException error", (Object)this.instanceId, (Object)e);
        }
        constructor.setAccessible(true);
        try {
            this.extendedHandler = (ExtendedHandler)constructor.newInstance(this.profile);
        }
        catch (InstantiationException e) {
            LOGGER.error("init {} InstantiationException error", (Object)this.instanceId, (Object)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("init {} IllegalAccessException error", (Object)this.instanceId, (Object)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("init {} InvocationTargetException error", (Object)this.instanceId, (Object)e);
        }
    }

    public Message read() {
        SourceData sourceData = this.readFromQueue();
        while (sourceData != null) {
            Message msg = this.createMessage(sourceData);
            if (this.filterSourceData(msg)) {
                long auditTime = 0L;
                auditTime = this.isRealTime ? AgentUtils.getCurrentTime() : this.profile.getSinkDataTime();
                Map header = msg.getHeader();
                AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_READ_SUCCESS, (String)this.inlongGroupId, (String)((String)header.get("inlongStreamId")), (long)auditTime, (int)1, (long)sourceData.getData().length, (long)this.auditVersion);
                AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_READ_SUCCESS_REAL_TIME, (String)this.inlongGroupId, (String)((String)header.get("inlongStreamId")), (long)AgentUtils.getCurrentTime(), (int)1, (long)sourceData.getData().length, (long)this.auditVersion);
                return msg;
            }
            sourceData = this.readFromQueue();
        }
        return null;
    }

    private boolean filterSourceData(Message msg) {
        if (this.extendedHandler != null) {
            return this.extendedHandler.filterMessage(msg);
        }
        return true;
    }

    private SourceData readFromQueue() {
        SourceData sourceData = null;
        try {
            sourceData = this.queue.poll(this.WAIT_TIMEOUT_MS.intValue(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("poll {} data get interrupted.", (Object)this.instanceId);
        }
        if (sourceData == null) {
            LOGGER.debug("Read from source queue null {}", (Object)this.inlongGroupId);
            return null;
        }
        LOGGER.debug("Read from source queue {} {}", (Object)new String(sourceData.getData()), (Object)this.inlongGroupId);
        MemoryManager.getInstance().release("agent.global.reader.queue.permit", sourceData.getData().length);
        return sourceData;
    }

    private Message createMessage(SourceData sourceData) {
        DefaultMessage finalMsg;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("offset", sourceData.getOffset());
        header.put("inlongStreamId", this.inlongStreamId);
        if (this.extendedHandler != null) {
            this.extendedHandler.dealWithHeader(header, sourceData.getData());
        }
        if ((finalMsg = new DefaultMessage(sourceData.getData(), header)).getBody().length > this.maxPackSize) {
            LOGGER.warn("message size is {}, greater than max pack size {}, drop it!", (Object)finalMsg.getBody().length, (Object)this.maxPackSize);
            return null;
        }
        return finalMsg;
    }

    protected abstract boolean isRunnable();

    public void stopRunning() {
        this.runnable = false;
    }

    public void destroy() {
        LOGGER.info("destroy read source name {}", (Object)this.instanceId);
        this.stopRunning();
        while (this.running) {
            AgentUtils.silenceSleepInMs((long)1L);
        }
        this.clearQueue(this.queue);
        this.releaseSource();
        LOGGER.info("destroy read source name {} end", (Object)this.instanceId);
    }

    protected abstract void releaseSource();

    private void clearQueue(BlockingQueue<SourceData> queue) {
        if (queue == null) {
            return;
        }
        while (queue != null && !queue.isEmpty()) {
            SourceData sourceData = null;
            try {
                sourceData = queue.poll(this.WAIT_TIMEOUT_MS.intValue(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.warn("poll {} data get interrupted.", (Object)this.instanceId, (Object)e);
            }
            if (sourceData == null) continue;
            MemoryManager.getInstance().release("agent.global.reader.queue.permit", sourceData.getData().length);
        }
        queue.clear();
    }

    public boolean sourceFinish() {
        if (this.sourceError) {
            return true;
        }
        if (this.isRealTime) {
            return false;
        }
        if (this.emptyCount == 0L) {
            return false;
        }
        if (this.profile.isRetry()) {
            return true;
        }
        return AgentUtils.getCurrentTime() - this.getLastModifyTime() > (long)this.SOURCE_NO_UPDATE_INTERVAL_MS.intValue();
    }

    public long getLastModifyTime() {
        return 0L;
    }

    protected class SourceData {
        private byte[] data;
        private String offset;

        public byte[] getData() {
            return this.data;
        }

        public String getOffset() {
            return this.offset;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public void setOffset(String offset) {
            this.offset = offset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceData)) {
                return false;
            }
            SourceData other = (SourceData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getData(), other.getData())) {
                return false;
            }
            String this$offset = this.getOffset();
            String other$offset = other.getOffset();
            return !(this$offset == null ? other$offset != null : !this$offset.equals(other$offset));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SourceData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getData());
            String $offset = this.getOffset();
            result = result * 59 + ($offset == null ? 43 : $offset.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractSource.SourceData(data=" + Arrays.toString(this.getData()) + ", offset=" + this.getOffset() + ")";
        }

        public SourceData(byte[] data, String offset) {
            this.data = data;
            this.offset = offset;
        }

        public SourceData() {
        }
    }
}

