/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.oceanbase;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.util.UrlVerificationUtils;
import org.apache.inlong.manager.pojo.sink.oceanbase.OceanBaseColumnInfo;
import org.apache.inlong.manager.pojo.sink.oceanbase.OceanBaseTableInfo;
import org.apache.inlong.manager.pojo.util.MySQLSensitiveUrlUtils;
import org.apache.inlong.manager.service.resource.sink.oceanbase.OceanBaseSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanBaseJdbcUtils {
    private static final String OCEANBASE_JDBC_PREFIX = "jdbc:oceanbase://";
    private static final String OCEANBASE_DRIVER_CLASS = "com.oceanbase.jdbc.Driver";
    private static final Logger LOGGER = LoggerFactory.getLogger(OceanBaseJdbcUtils.class);

    public static Connection getConnection(String url, String user, String password) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)url) && StringUtils.isNotBlank((CharSequence)url) && StringUtils.isNotBlank((CharSequence)password)) {
            UrlVerificationUtils.extractHostAndValidatePortFromJdbcUrl((String)url, (String)OCEANBASE_JDBC_PREFIX);
            return OceanBaseJdbcUtils.establishDatabaseConnection(url, user, password);
        }
        return null;
    }

    private static Connection establishDatabaseConnection(String url, String user, String password) throws Exception {
        Connection conn;
        if (StringUtils.isBlank((CharSequence)url) || !url.startsWith(OCEANBASE_JDBC_PREFIX)) {
            throw new Exception("OceanusBase URL is invalid, it should start with jdbc:oceanbase");
        }
        try {
            UrlVerificationUtils.extractHostAndValidatePortFromJdbcUrl((String)url, (String)OCEANBASE_JDBC_PREFIX);
            url = MySQLSensitiveUrlUtils.filterSensitive((String)url);
            Class.forName(OCEANBASE_DRIVER_CLASS);
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            String errorMsg = "Failed to get OceanBase connection, please check OceanBase JDBC URL, username, or password!";
            LOGGER.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg + " Other error message: " + e.getMessage());
        }
        if (conn == null) {
            throw new Exception("get OceanBase connection failed, please contact administrator");
        }
        LOGGER.info("get OceanBase connection success for url={}", (Object)url);
        return conn;
    }

    public static void executeSql(Connection conn, String sql) throws Exception {
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql);
            LOGGER.info("execute sql [{}] success", (Object)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlBatch(Connection conn, List<String> sqls) throws Exception {
        conn.setAutoCommit(false);
        try (Statement stmt = conn.createStatement();){
            for (String entry : sqls) {
                stmt.execute(entry);
            }
            conn.commit();
            LOGGER.info("execute sql [{}] success", sqls);
        }
        finally {
            conn.setAutoCommit(true);
        }
    }

    public static void createDb(Connection conn, String dbName) throws Exception {
        if (!OceanBaseJdbcUtils.checkDbExist(conn, dbName)) {
            String createDbSql = OceanBaseSqlBuilder.buildCreateDbSql(dbName);
            OceanBaseJdbcUtils.executeSql(conn, createDbSql);
            LOGGER.info("execute sql [{}] success", (Object)createDbSql);
        } else {
            LOGGER.info("The database [{}] are exists", (Object)dbName);
        }
    }

    public static boolean checkDbExist(Connection conn, String dbName) throws Exception {
        String checkDbSql = OceanBaseSqlBuilder.getCheckDatabase(dbName);
        try (Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery(checkDbSql);){
            if (Objects.nonNull(resultSet) && resultSet.next()) {
                LOGGER.info("check db exist for db={}, result=true", (Object)dbName);
                boolean bl = true;
                return bl;
            }
        }
        LOGGER.info("check db exist for db={}, result=false", (Object)dbName);
        return false;
    }

    public static void createTable(Connection conn, OceanBaseTableInfo tableInfo) throws Exception {
        if (OceanBaseJdbcUtils.checkTablesExist(conn, tableInfo.getDbName(), tableInfo.getTableName())) {
            LOGGER.info("The table [{}] are exists", (Object)tableInfo.getTableName());
        } else {
            String createTableSql = OceanBaseSqlBuilder.buildCreateTableSql(tableInfo);
            OceanBaseJdbcUtils.executeSql(conn, createTableSql);
            LOGGER.info("execute sql [{}] success", (Object)createTableSql);
        }
    }

    public static boolean checkTablesExist(Connection conn, String dbName, String tableName) throws Exception {
        boolean result = false;
        String checkTableSql = OceanBaseSqlBuilder.getCheckTable(dbName, tableName);
        try (Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery(checkTableSql);){
            if (Objects.nonNull(resultSet) && resultSet.next()) {
                result = true;
            }
        }
        LOGGER.info("check table exist for db={} table={}, result={}", new Object[]{dbName, tableName, result});
        return result;
    }

    public static boolean checkColumnExist(Connection conn, String dbName, String tableName, String column) throws Exception {
        boolean result = false;
        String checkTableSql = OceanBaseSqlBuilder.getCheckColumn(dbName, tableName, column);
        try (Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery(checkTableSql);){
            if (Objects.nonNull(resultSet) && resultSet.next()) {
                result = true;
            }
        }
        LOGGER.info("check column exist for db={} table={}, result={} column={}", new Object[]{dbName, tableName, result, column});
        return result;
    }

    public static List<OceanBaseColumnInfo> getColumns(Connection conn, String dbName, String tableName) throws Exception {
        String querySql = OceanBaseSqlBuilder.buildDescTableSql(dbName, tableName);
        ArrayList<OceanBaseColumnInfo> columnList = new ArrayList<OceanBaseColumnInfo>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(querySql);){
            if (Objects.nonNull(rs)) {
                while (rs.next()) {
                    OceanBaseColumnInfo columnInfo = new OceanBaseColumnInfo(rs.getString(1), rs.getString(2), rs.getString(3));
                    columnList.add(columnInfo);
                }
            }
        }
        return columnList;
    }

    public static void addColumns(Connection conn, String dbName, String tableName, List<OceanBaseColumnInfo> columns) throws Exception {
        ArrayList columnInfos = Lists.newArrayList();
        for (OceanBaseColumnInfo columnInfo : columns) {
            if (OceanBaseJdbcUtils.checkColumnExist(conn, dbName, tableName, columnInfo.getName())) continue;
            columnInfos.add(columnInfo);
        }
        List<String> addColumnSql = OceanBaseSqlBuilder.buildAddColumnsSql(dbName, tableName, columnInfos);
        OceanBaseJdbcUtils.executeSqlBatch(conn, addColumnSql);
    }
}

