/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.sqlserver;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.sink.sqlserver.SQLServerColumnInfo;
import org.apache.inlong.manager.pojo.sink.sqlserver.SQLServerSinkDTO;
import org.apache.inlong.manager.pojo.sink.sqlserver.SQLServerTableInfo;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.sqlserver.SQLServerJdbcUtils;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SQLServerResourceOperator
implements SinkResourceOperator {
    private static final Logger LOG = LoggerFactory.getLogger(SQLServerResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper fieldEntityMapper;

    @Override
    public Boolean accept(String sinkType) {
        return "SQLSERVER".equals(sinkType);
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        LOG.info("begin to create SQLServer resources sinkId={}", (Object)sinkInfo.getId());
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOG.warn("SQLServer resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOG.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTable(sinkInfo);
    }

    private void createTable(SinkInfo sinkInfo) {
        LOG.info("begin to create SQLServer table for sinkId={}", (Object)sinkInfo.getId());
        List fieldList = this.fieldEntityMapper.selectBySinkId(sinkInfo.getId());
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            LOG.warn("no SQLServer fields found, skip to create table for sinkId={}", (Object)sinkInfo.getId());
        }
        ArrayList columnList = Lists.newArrayList();
        fieldList.forEach(field -> {
            SQLServerColumnInfo columnInfo = new SQLServerColumnInfo(field.getFieldName(), field.getFieldType(), field.getFieldComment());
            columnList.add(columnInfo);
        });
        SQLServerSinkDTO sink = SQLServerSinkDTO.getFromJson((String)sinkInfo.getExtParams());
        SQLServerTableInfo tableInfo = SQLServerSinkDTO.getTableInfo((SQLServerSinkDTO)sink, (List)columnList);
        try (Connection conn = SQLServerJdbcUtils.getConnection(sink.getJdbcUrl(), sink.getUsername(), sink.getPassword());){
            SQLServerJdbcUtils.createSchema(conn, tableInfo.getSchemaName());
            SQLServerJdbcUtils.createTable(conn, tableInfo);
            SQLServerJdbcUtils.addColumns(conn, tableInfo.getSchemaName(), tableInfo.getTableName(), columnList);
            String info = "success to create SQLServer resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), "success to create SQLServer resource");
            LOG.info("success to create SQLServer resource for sinkInfo={}", (Object)sinkInfo);
        }
        catch (Throwable e) {
            String errMsg = "create SQLServer table failed: " + e.getMessage();
            LOG.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
        LOG.info("success create SQLServer table for data sink [" + sinkInfo.getId() + "]");
    }
}

