/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.example;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.client.config.ConsumerConfig;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.consumer.ConsumePosition;
import org.apache.inlong.tubemq.client.consumer.ConsumerResult;
import org.apache.inlong.tubemq.client.consumer.PullMessageConsumer;
import org.apache.inlong.tubemq.client.factory.MessageSessionFactory;
import org.apache.inlong.tubemq.client.factory.TubeMultiSessionFactory;
import org.apache.inlong.tubemq.corebase.cluster.MasterInfo;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.example.MsgSendReceiveStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagePullSetConsumerExample {
    private static final Logger logger = LoggerFactory.getLogger(MessagePullSetConsumerExample.class);
    private static final MsgSendReceiveStats msgRcvStats = new MsgSendReceiveStats(false);
    private static final ConcurrentHashMap<String, MessageSessionFactory> multSessFtyMap = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Throwable {
        void var19_28;
        String masterServers = args[0];
        String subTopicAndFiterItems = args[1];
        String groupName = args[2];
        int consumeCount = Integer.parseInt(args[3]);
        int fetchThreadCnt = 3;
        if (args.length > 4) {
            fetchThreadCnt = MixedUtils.mid((int)Integer.parseInt(args[4]), (int)1, (int)Runtime.getRuntime().availableProcessors());
        }
        Map topicAndFiltersMap = MixedUtils.parseTopicParam((String)subTopicAndFiterItems);
        Thread statisticThread = new Thread((Runnable)msgRcvStats, "Receive Statistic Thread");
        statisticThread.start();
        logger.info("The first consumption begin!");
        PullMessageConsumer consumer1 = MessagePullSetConsumerExample.createPullConsumer(masterServers, groupName);
        for (Map.Entry entry : topicAndFiltersMap.entrySet()) {
            consumer1.subscribe((String)entry.getKey(), (TreeSet)entry.getValue());
        }
        String sessionKeyFst = "test_consume_first";
        int sourceCountFst = 1;
        boolean isSelectBig = false;
        ConcurrentHashMap<String, Long> partOffsetMapFst = new ConcurrentHashMap<String, Long>();
        consumer1.completeSubscribe(sessionKeyFst, sourceCountFst, isSelectBig, partOffsetMapFst);
        Thread[] fetchRunners1 = new Thread[fetchThreadCnt];
        for (int i = 0; i < fetchRunners1.length; ++i) {
            fetchRunners1[i] = new Thread((Runnable)new FetchRequestRunner(consumer1, partOffsetMapFst, consumeCount), "_fetch_runner_" + i);
        }
        for (Thread thread : fetchRunners1) {
            thread.start();
        }
        ThreadUtils.sleep((long)120000L);
        logger.info("The first consumption has finished!");
        consumer1.shutdown();
        for (Thread thread : fetchRunners1) {
            thread.join();
        }
        logger.info("The second consumption begin!");
        String sessionKeySec = "test_consume_Second";
        int sourceCountSec = 1;
        ConcurrentHashMap<String, Long> partOffsetMapSec = new ConcurrentHashMap<String, Long>();
        for (Object partKey : partOffsetMapFst.keySet()) {
            partOffsetMapSec.put((String)partKey, 0L);
        }
        PullMessageConsumer pullMessageConsumer = MessagePullSetConsumerExample.createPullConsumer(masterServers, groupName);
        for (Map.Entry entry : topicAndFiltersMap.entrySet()) {
            pullMessageConsumer.subscribe((String)entry.getKey(), (TreeSet)entry.getValue());
        }
        pullMessageConsumer.completeSubscribe(sessionKeySec, sourceCountSec, isSelectBig, partOffsetMapSec);
        Thread[] fetchRunners2 = new Thread[fetchThreadCnt];
        boolean bl = false;
        while (var19_28 < fetchRunners2.length) {
            fetchRunners2[var19_28] = new Thread((Runnable)new FetchRequestRunner(pullMessageConsumer, partOffsetMapSec, consumeCount), "_fetch_runner_" + (int)var19_28);
            ++var19_28;
        }
        for (Thread thread : fetchRunners2) {
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PullMessageConsumer createPullConsumer(String masterHostAndPorts, String groupName) throws Exception {
        MessageSessionFactory sessionFactory;
        ConsumerConfig consumerConfig = new ConsumerConfig(masterHostAndPorts, groupName);
        consumerConfig.setConsumePosition(ConsumePosition.CONSUMER_FROM_LATEST_OFFSET);
        MasterInfo masterInfo = consumerConfig.getMasterInfo();
        ConcurrentHashMap<String, MessageSessionFactory> concurrentHashMap = multSessFtyMap;
        synchronized (concurrentHashMap) {
            sessionFactory = multSessFtyMap.get(masterInfo.getMasterClusterStr());
            if (sessionFactory == null) {
                sessionFactory = new TubeMultiSessionFactory((TubeClientConfig)consumerConfig);
                multSessFtyMap.put(masterInfo.getMasterClusterStr(), sessionFactory);
            }
        }
        return sessionFactory.createPullConsumer(consumerConfig);
    }

    private static class FetchRequestRunner
    implements Runnable {
        final PullMessageConsumer pullConsumer;
        final ConcurrentHashMap<String, Long> partOffsetMap;
        final int consumeCount;

        FetchRequestRunner(PullMessageConsumer messageConsumer, ConcurrentHashMap<String, Long> partOffsetMap, int msgCount) {
            this.pullConsumer = messageConsumer;
            this.partOffsetMap = partOffsetMap;
            this.consumeCount = msgCount;
        }

        @Override
        public void run() {
            int getCount = this.consumeCount;
            while (!this.pullConsumer.isPartitionsReady(5000L) && !this.pullConsumer.isShutdown()) {
            }
            block3: while (true) {
                try {
                    do {
                        if (this.pullConsumer.isShutdown()) {
                            logger.warn("Consumer is shutdown!");
                            break block3;
                        }
                        ConsumerResult csmResult = this.pullConsumer.getMessage();
                        if (!csmResult.isSuccess()) continue;
                        List messageList = csmResult.getMessageList();
                        if (messageList != null && !messageList.isEmpty()) {
                            msgRcvStats.addMsgCount(csmResult.getTopicName(), messageList.size());
                        }
                        this.partOffsetMap.put(csmResult.getPartitionKey(), csmResult.getCurrOffset());
                        ConsumerResult cfmResult = this.pullConsumer.confirmConsume(csmResult.getConfirmContext(), true);
                        if (!cfmResult.isSuccess()) continue;
                        this.partOffsetMap.put(csmResult.getPartitionKey(), csmResult.getCurrOffset());
                    } while (this.consumeCount <= 0 || --getCount > 0);
                    logger.info("Consumer has consumed {} messages!", (Object)this.consumeCount);
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
            logger.info("The fetch thread has exited!");
        }
    }
}

