/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.rest.core.mapping.HttpMethods;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public class ConfigurableHttpMethods
implements HttpMethods {
    public static final ConfigurableHttpMethods NONE = ConfigurableHttpMethods.of(new HttpMethod[0]);
    public static final ConfigurableHttpMethods ALL = ConfigurableHttpMethods.of(HttpMethod.values());
    private final Collection<HttpMethod> methods;

    private ConfigurableHttpMethods(Collection<HttpMethod> methods) {
        Assert.notNull(methods, (String)"HttpMethods must not be null!");
        this.methods = methods;
    }

    static ConfigurableHttpMethods of(Collection<HttpMethod> methods) {
        return new ConfigurableHttpMethods(methods);
    }

    static ConfigurableHttpMethods of(HttpMethod ... methods) {
        Assert.notNull((Object)methods, (String)"HttpMethods must not be null!");
        return new ConfigurableHttpMethods(Arrays.stream(methods).collect(Collectors.toSet()));
    }

    static ConfigurableHttpMethods of(HttpMethods methods) {
        Assert.notNull((Object)methods, (String)"HttpMethods must not be null!");
        if (ConfigurableHttpMethods.class.isInstance(methods)) {
            return (ConfigurableHttpMethods)ConfigurableHttpMethods.class.cast(methods);
        }
        return new ConfigurableHttpMethods(methods.stream().collect(Collectors.toSet()));
    }

    public ConfigurableHttpMethods disable(HttpMethod ... methods) {
        Assert.notNull((Object)methods, (String)"HttpMethods must not be null!");
        List<HttpMethod> toRemove = Arrays.asList(methods);
        return new ConfigurableHttpMethods(this.methods.stream().filter(it -> !toRemove.contains(it)).collect(Collectors.toSet()));
    }

    public ConfigurableHttpMethods enable(HttpMethod ... methods) {
        Assert.notNull((Object)methods, (String)"HttpMethods must not be null!");
        List<HttpMethod> toAdd = Arrays.asList(methods);
        if (this.methods.containsAll(toAdd)) {
            return this;
        }
        return ConfigurableHttpMethods.of(Stream.concat(this.methods.stream(), toAdd.stream()).collect(Collectors.toSet()));
    }

    @Override
    public boolean contains(HttpMethod method) {
        Assert.notNull((Object)method, (String)"HTTP method must not be null!");
        return this.methods.contains(method);
    }

    public Iterator<HttpMethod> iterator() {
        return this.methods.iterator();
    }
}

