/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.pojo.sort.dataflow.field.format;

import java.nio.charset.StandardCharsets;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.BasicFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.BinaryTypeInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.TypeInfo;

public class BinaryFormatInfo
implements BasicFormatInfo<byte[]> {
    private static final long serialVersionUID = 8379022656220694709L;
    public static final BinaryFormatInfo INSTANCE = new BinaryFormatInfo();
    public static final int MIN_LENGTH = 1;
    public static final int MAX_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_LENGTH = 1;
    @JsonProperty(value="length")
    private int length;

    public BinaryFormatInfo() {
        this(1);
    }

    @JsonCreator
    public BinaryFormatInfo(@JsonProperty(value="length") int length) {
        if (length < 1) {
            throw new IllegalArgumentException(String.format("Binary string length must be between %d and %d (both inclusive).", 1, Integer.MAX_VALUE));
        }
        this.length = length;
    }

    @Override
    public String serialize(byte[] record) throws Exception {
        return new String(record, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] deserialize(String text) throws Exception {
        return text.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return BinaryTypeInfo.INSTANCE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "BinaryFormatInfo";
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

