/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.deserialization;

import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.protocol.deserialization.DeserializationInfo;

public class CanalDeserializationInfo
implements DeserializationInfo {
    private static final long serialVersionUID = -5344203248610337314L;
    @JsonProperty(value="database")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String database;
    @JsonProperty(value="table")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String table;
    @JsonProperty(value="ignore_parse_errors")
    private final boolean ignoreParseErrors;
    @JsonProperty(value="timestamp_format_standard")
    private final String timestampFormatStandard;
    @Deprecated
    @JsonProperty(value="include_metadata")
    private final boolean includeMetadata;

    @JsonCreator
    public CanalDeserializationInfo(@JsonProperty(value="database") String database, @JsonProperty(value="table") String table, @JsonProperty(value="ignore_parse_errors") boolean ignoreParseErrors, @JsonProperty(value="timestamp_format_standard") String timestampFormatStandard, @JsonProperty(value="include_metadata") boolean includeMetadata) {
        this.database = database;
        this.table = table;
        this.ignoreParseErrors = ignoreParseErrors;
        this.timestampFormatStandard = timestampFormatStandard;
        this.includeMetadata = includeMetadata;
    }

    @JsonProperty(value="database")
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty(value="table")
    public String getTable() {
        return this.table;
    }

    @JsonProperty(value="ignore_parse_errors")
    public boolean isIgnoreParseErrors() {
        return this.ignoreParseErrors;
    }

    @JsonProperty(value="timestamp_format_standard")
    public String getTimestampFormatStandard() {
        return this.timestampFormatStandard;
    }

    @JsonProperty(value="include_metadata")
    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanalDeserializationInfo that = (CanalDeserializationInfo)o;
        return this.ignoreParseErrors == that.ignoreParseErrors && this.includeMetadata == that.includeMetadata && Objects.equals(this.database, that.database) && Objects.equals(this.table, that.table) && Objects.equals(this.timestampFormatStandard, that.timestampFormatStandard);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.table, this.ignoreParseErrors, this.timestampFormatStandard, this.includeMetadata);
    }
}

