/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.deserialization;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.protocol.constant.Constant;
import org.apache.inlong.sort.protocol.deserialization.InLongMsgDeserializationInfo;

public class CsvDeserializationInfo
extends InLongMsgDeserializationInfo {
    private static final long serialVersionUID = 7424482369272150638L;
    private final char splitter;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final Character escapeChar;
    private final String streamId;
    @JsonProperty(value="delete_escape_char_while_deserialize")
    @Nullable
    private final Boolean deleteEscapeCharWhileDes;
    @JsonProperty(value="auto_append_escape_char_after_deserialize")
    @Nullable
    private final Boolean autoAppendEscapeCharAfterDes;

    public CsvDeserializationInfo(@JsonProperty(value="splitter") char splitter) {
        this("-", splitter, null, Constant.DELETE_ESCAPE_CHAR_WHILE_DESERIALIZE_DEFAULT, Constant.AUTO_APPEND_ESCAPE_CHAR_AFTER_DESERIALIZE_DEFAULT);
    }

    public CsvDeserializationInfo(@JsonProperty(value="splitter") char splitter, @JsonProperty(value="escape_char") @Nullable Character escapeChar) {
        this("-", splitter, escapeChar, Constant.DELETE_ESCAPE_CHAR_WHILE_DESERIALIZE_DEFAULT, Constant.AUTO_APPEND_ESCAPE_CHAR_AFTER_DESERIALIZE_DEFAULT);
    }

    @JsonCreator
    public CsvDeserializationInfo(@JsonProperty(value="streamId") String streamId, @JsonProperty(value="splitter") char splitter, @JsonProperty(value="escape_char") @Nullable Character escapeChar, @JsonProperty(value="delete_escape_char_while_deserialize") @Nullable Boolean deleteEscapeCharWhileDes, @JsonProperty(value="auto_append_escape_char_after_deserialize") @Nullable Boolean autoAppendEscapeCharAfterDes) {
        super(streamId);
        this.streamId = StringUtils.isEmpty((CharSequence)streamId) ? "-" : streamId;
        this.splitter = splitter;
        this.escapeChar = escapeChar;
        this.deleteEscapeCharWhileDes = deleteEscapeCharWhileDes;
        this.autoAppendEscapeCharAfterDes = autoAppendEscapeCharAfterDes;
    }

    @JsonProperty(value="splitter")
    public char getSplitter() {
        return this.splitter;
    }

    @JsonProperty(value="escape_char")
    @Nullable
    public Character getEscapeChar() {
        return this.escapeChar;
    }

    @Override
    @JsonProperty(value="streamId")
    public String getStreamId() {
        return this.streamId;
    }

    @JsonProperty(value="delete_escape_char_while_deserialize")
    @Nullable
    public Boolean getDeleteEscapeCharWhileDes() {
        if (this.deleteEscapeCharWhileDes != null) {
            return this.deleteEscapeCharWhileDes;
        }
        return Constant.DELETE_ESCAPE_CHAR_WHILE_DESERIALIZE_DEFAULT;
    }

    @JsonProperty(value="auto_append_escape_char_after_deserialize")
    @Nullable
    public Boolean getAutoAppendEscapeCharAfterDes() {
        if (this.autoAppendEscapeCharAfterDes != null) {
            return this.autoAppendEscapeCharAfterDes;
        }
        return Constant.AUTO_APPEND_ESCAPE_CHAR_AFTER_DESERIALIZE_DEFAULT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvDeserializationInfo other = (CsvDeserializationInfo)o;
        return Objects.equals(this.streamId, other.getStreamId()) && this.splitter == other.splitter && Objects.equals(this.escapeChar, other.escapeChar) && Objects.equals(this.deleteEscapeCharWhileDes, other.deleteEscapeCharWhileDes) && Objects.equals(this.autoAppendEscapeCharAfterDes, other.autoAppendEscapeCharAfterDes);
    }
}

